/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
/**
 * Gets a telemetry-safe stable device ID.
 * @returns A telemetry-safe stable device ID.
 */
export declare function deviceId(): Promise<string>;
/**
 * Gets the device architecture, like x86/x64/arm64.
 * @returns The device architecture.
 */
export declare function deviceArchitecture(): string;
/**
 * Gets the node architecture, like x86/x64/arm64.
 * @returns The node architecture.
 */
export declare function nodeArchitecture(): string;
/**
 * Gets the device platform, like darwin/linux/win32.
 * @returns The device platform.
 */
export declare function devicePlatform(): string;
/**
 * Gets the device locale.
 * @returns The device locale.
 */
export declare function deviceLocale(): Promise<string>;
/**
 * Gets the device's number of CPUs.
 * @returns The device's number of CPUs.
 */
export declare function deviceNumCPUs(): number;
/**
 * Gets the device's total memory in bytes.
 * @returns The device's total memory in bytes.
 */
export declare function deviceTotalMemory(): number;
/**
 * Gets the free space of the give drive in bytes.
 * @param drivePath A path on the drive to check.
 * @returns The free space of the give drive in bytes.
 */
export declare function deviceDiskFreeSpace(drivePath?: string | null): number;
/**
 * Gets the telemetry sample rate.
 * @returns The telemetry sample rate.
 */
export declare function sampleRate(): number;
/**
 * Gets whether or not telemetry events are captured when running in CI.
 * @returns Whether or not telemetry events are captured when running in CI.
 */
export declare function captureCI(): boolean;
/**
 * Gets the whether the process is currently running in CI.
 * @returns Whether the process is currently running in CI.
 */
export declare function isCI(): boolean;
/**
 * Gets the type of CI the process is running under.
 * @returns The type of CI the process is running under.
 */
export declare function ciType(): string;
/**
 * Gets whether the process is running on a Microsoft owned machine.
 * @returns Whether the process is running on a Microsoft owned machine.
 */
export declare function isMsftInternal(): boolean;
/**
 * Gets whether the process is running as part of our CLI tests.
 * @returns Whether the process is running as part of our CLI tests.
 */
export declare function isCliTest(): boolean;
/**
 * Gets a stable session ID for correlating telemetry events.
 * @returns A stable session ID for correlating telemetry events.
 */
export declare function getSessionId(): string;
