"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const sanitizeUtils = __importStar(require("../utils/sanitizeUtils"));
const projectDir = process.cwd();
test('getAnonymizedPath() with project dir is anonymized', () => {
    const originalPath = projectDir;
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[project_dir]')).toBe(true);
});
test('getAnonymizedPath() with project/index.js is anonymized', () => {
    const originalPath = path_1.default.join(projectDir, 'index.js');
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[project_dir]\\???.js')).toBe(true);
});
test('getAnonymizedPath() with project/windows/test.sln is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(projectDir, 'windows/test.sln'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[windows]\\???.sln')).toBe(true);
});
test('getAnonymizedPath() with project/node_modules for untracked package is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(projectDir, 'node_modules/untracked/index.js'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[node_modules]\\???.js')).toBe(true);
});
test('getAnonymizedPath() with project/node_modules for react-secret-pii package is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(projectDir, 'node_modules/react-secret-pii/index.js'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[node_modules]\\???.js')).toBe(true);
});
test('getAnonymizedPath() with path under react-native-windows is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(projectDir, 'node_modules/react-native-windows/index.js'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath).toBe('[node_modules]\\react-native-windows\\index.js');
});
test('getAnonymizedPath() with path under @react-native-windows/cli is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(projectDir, 'node_modules/@react-native-windows/cli/index.js'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath).toBe('[node_modules]\\@react-native-windows\\cli\\index.js');
});
test('getAnonymizedPath() with path under %%LocalAppData%% is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(process.env.LocalAppData, 'test.sln'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath.startsWith('[LocalAppData]\\???')).toBe(true);
});
test('getAnonymizedPath() with a tracked npm package under %%LocalAppData%% is anonymized', () => {
    const originalPath = path_1.default.normalize(path_1.default.join(process.env.LocalAppData, 'node_modules/@react-native-windows/cli/index.js'));
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath).toBe('[node_modules]\\@react-native-windows\\cli\\index.js');
});
test('getAnonymizedPath() with arbitrary path not under project dir is anonymized', () => {
    const originalPath = 'test.sln';
    const anonymizedPath = sanitizeUtils.getAnonymizedPath(originalPath);
    expect(anonymizedPath).not.toBe(originalPath);
    expect(anonymizedPath).toBe('[path]');
});
//# sourceMappingURL=sanitizeUtils.test.js.map