"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.configure = configure;
exports.deleteLogFiles = deleteLogFiles;
exports.getLogFilePaths = getLogFilePaths;
exports.write = write;
const RNTurboLog = require('./NativeRNTurboLog').default;
function configure(options = {}) {
  const opts = {
    dailyRolling: options.dailyRolling ?? false,
    maximumFileSize: options.maximumFileSize ?? 1024 * 1024,
    maximumNumberOfFiles: options.maximumNumberOfFiles ?? 5,
    logsDirectory: options.logsDirectory
  };
  return RNTurboLog.configure(opts);
}
function deleteLogFiles() {
  return RNTurboLog.deleteLogFiles();
}
function getLogFilePaths() {
  return RNTurboLog.getLogFilePaths();
}
function write(logLevel, message) {
  RNTurboLog.write(logLevel, message);
}
//# sourceMappingURL=native.js.map