"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _reactNative = require("react-native");
var _emmNative = _interopRequireDefault(require("./emm-native"));
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
const emitter = new _reactNative.NativeEventEmitter(_emmNative.default);
const Emm = {
  addListener: callback => {
    return emitter.addListener('managedConfigChanged', config => {
      callback(config);
    });
  },
  authenticate: async opts => {
    try {
      const options = {
        reason: opts.reason || '',
        description: opts.description || '',
        fallback: opts.fallback || true,
        supressEnterPassword: opts.supressEnterPassword || false,
        blurOnAuthenticate: opts.blurOnAuthenticate || false
      };
      await _emmNative.default.authenticate(options);
      return true;
    } catch {
      return false;
    }
  },
  getManagedConfig: () => _emmNative.default.getManagedConfig(),
  isDeviceSecured: async () => {
    try {
      const result = await _emmNative.default.deviceSecureWith();
      return result.face || result.fingerprint || result.passcode;
    } catch {
      return false;
    }
  },
  openSecuritySettings: () => {
    if (_reactNative.Platform.OS === 'android') {
      _emmNative.default.openSecuritySettings();
    }
  },
  setAppGroupId: identifier => {
    if (_reactNative.Platform.OS === 'ios') {
      _emmNative.default.setAppGroupId(identifier);
    }
  },
  deviceSecureWith: function () {
    return _emmNative.default.deviceSecureWith();
  },
  enableBlurScreen: function (enabled) {
    return _emmNative.default.setBlurScreen(enabled);
  },
  applyBlurEffect: (radius = 8) => _emmNative.default.applyBlurEffect(radius),
  removeBlurEffect: () => _emmNative.default.removeBlurEffect(),
  exitApp: function () {
    _emmNative.default.exitApp();
  }
};
var _default = exports.default = Emm;
//# sourceMappingURL=emm.js.map