"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.Provider = void 0;
exports.useManagedConfig = useManagedConfig;
exports.withManagedConfig = withManagedConfig;
var _react = _interopRequireWildcard(require("react"));
var _emm = _interopRequireDefault(require("./emm"));
var _jsxRuntime = require("react/jsx-runtime");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialContext = _emm.default.getManagedConfig();
const Context = /*#__PURE__*/(0, _react.createContext)(initialContext);
function useManagedConfig() {
  return (0, _react.useContext)(Context);
}
const Provider = ({
  children
}) => {
  const [managed, setManaged] = (0, _react.useState)(_emm.default.getManagedConfig());
  (0, _react.useEffect)(() => {
    const listener = _emm.default.addListener(config => {
      setManaged(config);
    });
    return () => {
      listener.remove();
    };
  });
  return /*#__PURE__*/(0, _jsxRuntime.jsx)(Context.Provider, {
    value: managed,
    children: children
  });
};
exports.Provider = Provider;
function withManagedConfig(Component) {
  return function ManagedConfigComponent(props) {
    return /*#__PURE__*/(0, _jsxRuntime.jsx)(Context.Consumer, {
      children: managedConfig => /*#__PURE__*/(0, _jsxRuntime.jsx)(Component, {
        ...props,
        managedConfig: managedConfig
      })
    });
  };
}
var _default = exports.default = Context;
//# sourceMappingURL=context.js.map