import { UnpackedZoneData } from '@formatjs/ecma402-abstract';
import Decimal from 'decimal.js';
export interface ToLocalTimeImplDetails {
    tzData: Record<string, UnpackedZoneData[]>;
}
/**
 * https://tc39.es/ecma402/#sec-tolocaltime
 * @param t
 * @param calendar
 * @param timeZone
 */
export declare function ToLocalTime(t: Decimal, calendar: string, timeZone: string, { tzData }: ToLocalTimeImplDetails): {
    weekday: number;
    era: string;
    year: number;
    relatedYear: undefined;
    yearName: undefined;
    month: number;
    day: number;
    hour: number;
    minute: number;
    second: number;
    millisecond: number;
    inDST: boolean;
    timeZoneOffset: number;
};
