# Notice.txt File Configuration

We are automatically generating Notice.txt by using first-level dependencies of the project. The related pipeline uses `config.yaml` stored in this folder.


## Configuration

Notice.txt will be always generated from first-level dependencies scanned from package.json files. For some cases it may be useful to define the
dependency to add its licence to the Notice.txt even if it is not first-level dependency or development dependency.

For instance at desktop project we need to add `wix`'s licence to the Notice.txt even if it is not a first-level dependency. To do that, define
all dependencies at `dependencies` array at the configuration. For any dependency at `dependencies` section, pipeline code will add their 
licenses to the Notice.txt file.

At webapp project `webpack` used in `devDependencies`, it is requested because we are using some files generated by `webpack`. If any dependency is
referenced at `devDependencies` section, pipeline will add those dependency licences when they are referenced at `package.json` files.

Sample:

```
title: "Mattermost Mobile"
copyright: "© 2016-present Mattermost, Inc.  All Rights Reserved.  See LICENSE.txt for license information."
description: "This document includes a list of open source components used in Mattermost Mobile, including those that have been modified."
reviewers: 
  - mattermost/release-managers
  - enahum
search:
  - "package.json"
dependencies:
  - "wix"
devDependencies: 
  - "webpack"
```

| Field | Type   | Purpose |
| :--   | :--    | :--     |
| title | string | Field content will be used as a title of the application. See first line of `NOTICE.txt` file. |
| copyright | string | Field content will be used as a copyright message. See second line of `NOTICE.txt` file. |
| description | string | Field content will be used as notice file description. See third line of `NOTICE.txt` file. |
| reviewers | array of GitHub user/teams | Those will be automatically assigned to the PRs as reviewers. |
| dependencies | array | If any dependency name mentioned, it will be automatically added even if it is not a first-level dependency. |
| devDependencies | array | If any dependency name mentioned, it will be added when it is referenced in devDependency section. |
| search | array | Pipeline will search for package.json files mentioned here. Globstar format is supported ie. `packages/**/package.json`. |


