// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import React from 'react';
import Svg, {Circle, ClipPath, Defs, G, Path, Rect} from 'react-native-svg';

import {useTheme} from '@context/theme';

function SearchIllustration() {
    const theme = useTheme();

    return (
        <Svg
            width='123'
            height='110'
            viewBox='0 0 123 110'
            fill='none'
        >
            <G clipPath='url(#clip0_4212_116720)'>
                <Rect
                    x={0.255005}
                    y={32}
                    width={107}
                    height={31}
                    rx={3.75}
                    fill={theme.buttonBg}
                    fillOpacity={0.12}
                />
                <Rect
                    x={46.255}
                    y={0}
                    width={76}
                    height={27}
                    rx={3.75}
                    fill={theme.buttonBg}
                    fillOpacity={0.12}
                />
                <Rect
                    x={46.255}
                    y={67}
                    width={76}
                    height={27}
                    rx={3.75}
                    fill={theme.buttonBg}
                    fillOpacity={0.12}
                />
                <Path
                    d='M62.5814 6.60593C70.262 6.55738 77.3232 8.54646 83.755 12.5732C86.3956 14.2264 88.9301 16.223 91.3579 18.5631C94.3589 21.6787 96.7911 24.9905 98.653 28.5M62.5813 87.8542C53.6129 87.7863 45.4964 85.1063 38.255 79.7911C36.7377 78.6774 35.2587 77.4479 33.8185 76.1025C30.0784 72.0903 27.2249 67.8234 25.255 63.299M21.9572 47.2301C21.964 41.8688 22.9467 36.7921 24.9051 32C26.8843 27.1573 29.8599 22.6053 33.8322 18.3439M101.949 37C102.786 40.2642 103.206 43.6739 103.206 47.2301C103.2 51.5308 102.585 55.6211 101.358 59.5M100.495 32.5C100.769 33.1979 101.022 33.903 101.255 34.6153'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                />
                <Path
                    d='M82.6551 5.72396C90.4991 9.4225 96.7179 14.8934 101.302 22.1318C103.184 25.1036 104.79 28.3733 106.12 31.9406'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.48}
                />
                <Rect
                    x={89.8878}
                    y={69.3516}
                    width={33.9752}
                    height={7.45395}
                    rx={1}
                    transform='rotate(45 89.8878 69.3516)'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.48}
                />
                <Rect
                    x={89.8878}
                    y={70.0587}
                    width={32.9752}
                    height={6.45395}
                    rx={0.5}
                    transform='rotate(45 89.8878 70.0587)'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Path
                    d='M62.5706 11.2232C72.1732 11.1625 80.6832 14.6952 88.0764 21.8213C95.0689 29.0809 98.5773 37.5423 98.5773 47.2299C98.5652 56.9053 95.0689 65.3789 88.0764 72.6385C80.6832 79.7646 72.1975 83.2973 62.5706 83.2366C52.9559 83.1637 44.4459 79.7039 37.077 72.8206C30.0724 65.3061 26.5761 56.7839 26.564 47.2299C26.5761 37.6759 30.0845 29.1416 37.0892 21.627C44.4702 14.7559 52.968 11.2839 62.5706 11.2232Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M62.5738 11.7232C72.0335 11.6634 80.418 15.1368 87.7227 22.1748C94.6257 29.3444 98.0773 37.6809 98.0773 47.2299C98.0652 56.7673 94.6251 65.1159 87.7228 72.2849C80.418 79.323 72.0576 82.7964 62.5738 82.7366C53.0959 82.6646 44.7093 79.2606 37.431 72.467C30.5135 65.0406 27.0759 56.6419 27.064 47.2294C27.0762 37.8176 30.5255 29.4072 37.4428 21.9809C44.7342 15.1984 53.109 11.783 62.5738 11.7232Z'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    d='M88.076 21.8213C80.6829 14.6952 72.1729 11.1625 62.5703 11.2232C52.9677 11.2839 44.4698 14.7559 37.0888 21.627C30.0841 29.1416 26.5757 37.6759 26.5636 47.2299C26.5757 56.7839 30.072 65.3061 37.0767 72.8206C44.4455 79.7039 52.9555 83.1638 62.5703 83.2366C72.1971 83.2973 80.6829 79.7646 88.076 72.6385C95.0685 65.3789 98.5648 56.9053 98.577 47.2299C98.577 37.5423 95.0685 29.0809 88.076 21.8213ZM84.5637 25.3086C78.1852 19.1606 70.8432 16.1128 62.5586 16.1652C54.274 16.2175 46.9424 19.213 40.5745 25.1411C34.5312 31.6242 31.5043 38.9872 31.4939 47.2299C31.5043 55.4726 34.5207 62.8251 40.564 69.3083C46.9215 75.2468 54.2635 78.2318 62.5586 78.2947C70.8642 78.347 78.1852 75.2992 84.5637 69.1512C90.5965 62.888 93.6129 55.5774 93.6233 47.2299C93.6233 38.872 90.5965 31.5719 84.5637 25.3086Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    fillRule='evenodd'
                    clipRule='evenodd'
                    d='M88.076 21.8213C80.6828 14.6952 72.1728 11.1625 62.5702 11.2232C52.9676 11.2839 44.4697 14.7559 37.0887 21.627C30.0841 29.1416 26.5757 37.6759 26.5635 47.2299C26.5757 56.7839 30.0719 65.3061 37.0766 72.8206C44.4455 79.7039 52.9555 83.1638 62.5702 83.2366C72.1971 83.2973 80.6828 79.7646 88.076 72.6385C95.0685 65.3789 98.5648 56.9053 98.5769 47.2299C98.5769 37.5423 95.0685 29.0809 88.076 21.8213ZM84.5636 25.3086C78.1852 19.1606 70.8432 16.1128 62.5585 16.1652C54.2739 16.2175 46.9424 19.213 40.5744 25.1411C34.5312 31.6242 31.5043 38.9872 31.4938 47.2299C31.5043 55.4726 34.5207 62.8251 40.564 69.3083C46.9214 75.2468 54.2634 78.2318 62.5585 78.2947C70.8641 78.347 78.1852 75.2992 84.5636 69.1512C90.5964 62.888 93.6128 55.5774 93.6233 47.2299C93.6233 38.872 90.5964 31.5719 84.5636 25.3086Z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.8}
                />
                <Path
                    d='M62.5736 11.7232C72.0333 11.6634 80.4179 15.1369 87.7225 22.1748C94.6255 29.3444 98.0771 37.681 98.0771 47.2299C98.065 56.7674 94.625 65.1159 87.7226 72.2849C80.4178 79.3231 72.0575 82.7964 62.5736 82.7366C53.0957 82.6647 44.7092 79.2607 37.4308 72.4671C30.5133 65.0407 27.0758 56.642 27.0638 47.2294C27.076 37.8176 30.5254 29.4072 37.4426 21.9809C44.734 15.1984 53.1088 11.783 62.5736 11.7232Z'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                />
                <Circle
                    cx={51.255}
                    cy={36}
                    r={9}
                    fill={theme.centerChannelColor}
                    fillOpacity={0.32}
                />
                <Path
                    d='M43.255 56H85.255'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                />
                <Path
                    d='M43.255 63H65.255'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                />
                <Path
                    d='M43.255 50H60.255'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                />
                <Path
                    d='M65.255 50H80.255'
                    stroke={theme.centerChannelColor}
                    strokeOpacity={0.8}
                    strokeLinecap='round'
                />
            </G>
            <Defs>
                <ClipPath id='clip0_4212_116720'>
                    <Rect
                        width={122}
                        height={99}
                        fill='white'
                        x={0.255005}
                        y={0}
                    />
                </ClipPath>
            </Defs>
        </Svg>
    );
}

export default SearchIllustration;
