"use strict";
var os = require("os");
var fs = require("fs");
var path = require("path");
var Contracts = require("../Declarations/Contracts");
var Constants_1 = require("../Declarations/Constants");
var Logging = require("./Logging");
var Context = /** @class */ (function () {
    function Context(packageJsonPath) {
        this.keys = new Contracts.ContextTagKeys();
        this.tags = {};
        this._loadApplicationContext(packageJsonPath);
        this._loadDeviceContext();
        this._loadInternalContext();
    }
    Context.prototype._loadApplicationContext = function (packageJsonPath) {
        try {
            packageJsonPath = packageJsonPath || path.resolve(__dirname, "../../../../package.json");
            if (!Context.appVersion[packageJsonPath]) {
                Context.appVersion[packageJsonPath] = "unknown";
                var packageJson = JSON.parse(fs.readFileSync(packageJsonPath, "utf8"));
                if (packageJson && typeof packageJson.version === "string") {
                    Context.appVersion[packageJsonPath] = packageJson.version;
                }
            }
            this.tags[this.keys.applicationVersion] = Context.appVersion[packageJsonPath];
        }
        catch (exception) {
            Logging.info("Failed to read app version: ", exception);
        }
    };
    Context.prototype._loadDeviceContext = function () {
        var cloudRoleInstance = os && os.hostname();
        var cloudRole = Context.DefaultRoleName;
        // Try to get more accurate roleName and instance when running in Azure
        if (process.env.WEBSITE_SITE_NAME) { // Azure Web apps and Functions
            cloudRole = process.env.WEBSITE_SITE_NAME;
        }
        if (process.env.WEBSITE_INSTANCE_ID) {
            cloudRoleInstance = process.env.WEBSITE_INSTANCE_ID;
        }
        this.tags[this.keys.deviceId] = "";
        this.tags[this.keys.cloudRoleInstance] = cloudRoleInstance;
        this.tags[this.keys.deviceOSVersion] = os && (os.type() + " " + os.release());
        this.tags[this.keys.cloudRole] = cloudRole;
        // not yet supported tags
        this.tags["ai.device.osArchitecture"] = os && os.arch();
        this.tags["ai.device.osPlatform"] = os && os.platform();
    };
    Context.prototype._loadInternalContext = function () {
        Context.sdkVersion = Constants_1.APPLICATION_INSIGHTS_SDK_VERSION;
        this.tags[this.keys.internalSdkVersion] = "node:" + Context.sdkVersion;
    };
    Context.DefaultRoleName = "Web";
    Context.appVersion = {};
    Context.sdkVersion = null;
    return Context;
}());
module.exports = Context;
//# sourceMappingURL=Context.js.map