import * as React from 'react';
import { Animated } from 'react-native';
import type { FeedbackWidgetStyles } from './FeedbackWidget.types';
interface FeedbackWidgetProviderProps {
    children: React.ReactNode;
    styles?: FeedbackWidgetStyles;
}
interface FeedbackWidgetProviderState {
    isVisible: boolean;
    backgroundOpacity: Animated.Value;
    panY: Animated.Value;
    isScrollAtTop: boolean;
}
declare class FeedbackWidgetProvider extends React.Component<FeedbackWidgetProviderProps> {
    state: FeedbackWidgetProviderState;
    private _panResponder;
    constructor(props: FeedbackWidgetProviderProps);
    /**
     * Animates the background opacity when the modal is shown.
     */
    componentDidUpdate(_prevProps: any, prevState: FeedbackWidgetProviderState): void;
    /**
     * Renders the feedback form modal.
     */
    render(): React.ReactNode;
    private _handleScroll;
    private _setVisibilityFunction;
    private _handleClose;
}
declare const showFeedbackWidget: () => void;
declare const resetFeedbackWidgetManager: () => void;
export { showFeedbackWidget, FeedbackWidgetProvider, resetFeedbackWidgetManager };
//# sourceMappingURL=FeedbackWidgetManager.d.ts.map
