/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 */
import type { CppStringTypes } from './generators/GenerateNM2';
import type { SchemaType } from '@react-native/codegen/lib/CodegenSchema';
export type { CppStringTypes } from './generators/GenerateNM2';
export interface SharedOptions {
    libraryName: string;
    methodOnly: boolean;
    modulesCxx: boolean;
    modulesTypeScriptTypes: boolean;
    modulesWindows: boolean;
    namespace: string;
    outputDirectory: string;
    cppStringType: CppStringTypes;
    separateDataTypes: boolean;
}
interface Options extends SharedOptions {
    moduleSpecName: string;
    schema: SchemaType;
}
interface Config {
    generators: any[];
    test?: boolean;
}
export declare function parseFile(filename: string): SchemaType;
export declare function combineSchemas(files: string[]): SchemaType;
export declare function generate({ libraryName, methodOnly, modulesCxx, modulesTypeScriptTypes, modulesWindows, namespace, outputDirectory, cppStringType, separateDataTypes, moduleSpecName, schema, }: Options, { /*generators,*/ test }: Config): boolean;
export interface CodeGenOptions extends SharedOptions {
    file?: string;
    files?: string[];
    test: boolean;
}
export declare function runCodeGen(options: CodeGenOptions): boolean;
