"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.projectConfigWindows = void 0;
// Types in this file are inaccurate compared to usage in terms of falsiness.
// We should try to rewrite some of this to do automated schema validation to
// guarantee correct types
/* eslint-disable @typescript-eslint/no-unnecessary-condition */
const os_1 = require("os");
const path_1 = __importDefault(require("path"));
const configUtils = __importStar(require("./configUtils"));
/**
 * Gets the config of any RNW apps under the target folder.
 * @param folder The absolute path to the target folder.
 * @param userConfig A manually specified override config.
 * @return The config if any RNW apps exist.
 */
// Disabled due to existing high cyclomatic complexity
// eslint-disable-next-line complexity
function projectConfigWindows(folder, userConfig = {}) {
    var _a;
    if ((0, os_1.platform)() !== 'win32') {
        return null;
    }
    if (userConfig === null) {
        return null;
    }
    const usingManualOverride = 'sourceDir' in userConfig;
    const sourceDir = usingManualOverride
        ? path_1.default.join(folder, userConfig.sourceDir)
        : configUtils.findWindowsFolder(folder);
    if (sourceDir === null) {
        // Nothing to look for here, bail
        return null;
    }
    const result = {
        folder: folder,
        sourceDir: path_1.default.relative(folder, sourceDir),
    };
    let validSolution = false;
    let validProject = false;
    if (usingManualOverride) {
        // Manual override, try to use it for solutionFile
        if (!('solutionFile' in userConfig)) {
            result.solutionFile =
                'Error: Solution file is required but not specified in react-native.config.';
        }
        else if (userConfig.solutionFile === null) {
            result.solutionFile =
                'Error: Solution file is null in react-native.config.';
        }
        else {
            result.solutionFile = path_1.default.normalize(userConfig.solutionFile);
            validSolution = true;
        }
        // Manual override, try to use it for project
        if (!('project' in userConfig)) {
            result.project = {
                projectFile: 'Error: Project is required but not specified in react-native.config.',
            };
        }
        else if (!userConfig.project) {
            result.project = {
                projectFile: 'Error: Project is null in react-native.config.',
            };
        }
        else {
            if (!('projectFile' in userConfig.project)) {
                result.project = {
                    projectFile: 'Error: Project file is required for project in react-native.config.',
                };
            }
            else if (userConfig.project.projectFile === null) {
                result.project = {
                    projectFile: 'Error: Project file is null in react-native.config.',
                };
            }
            else {
                result.project = {
                    projectFile: path_1.default.normalize(userConfig.project.projectFile),
                };
                validProject = true;
            }
        }
        if ('useWinUI3' in userConfig) {
            result.useWinUI3 = userConfig.useWinUI3;
        }
    }
    else {
        // No manually provided solutionFile, try to find it
        const foundSolutions = configUtils.findSolutionFiles(sourceDir);
        if (foundSolutions.length === 0) {
            result.solutionFile =
                'Error: No app solution file found, please specify in react-native.config.';
        }
        else if (foundSolutions.length > 1) {
            result.solutionFile =
                'Error: Too many app solution files found, please specify in react-native.config.';
        }
        else {
            result.solutionFile = path_1.default.normalize(foundSolutions[0]);
            validSolution = true;
        }
        // No manually provided project, try to find it
        const foundProjects = configUtils.findAppProjectFiles(sourceDir);
        if (foundProjects.length === 0) {
            result.project = {
                projectFile: 'Error: No app project file found, please specify in react-native.config.',
            };
        }
        else if (foundProjects.length > 1) {
            result.project = {
                projectFile: 'Error: Too many app project files found, please specify in react-native.config.',
            };
        }
        else {
            result.project = {
                projectFile: path_1.default.normalize(foundProjects[0]),
            };
            validProject = true;
        }
    }
    if (validSolution) {
        result.solutionFile = path_1.default.relative(sourceDir, path_1.default.join(sourceDir, result.solutionFile));
        // Populating experimental features from ExperimentalFeatures.props
        const experimentalFeatures = configUtils.getExperimentalFeatures(path_1.default.dirname(path_1.default.join(sourceDir, result.solutionFile)));
        if (experimentalFeatures) {
            result.experimentalFeatures = experimentalFeatures;
        }
    }
    if (validProject) {
        const projectFile = path_1.default.join(sourceDir, result.project.projectFile);
        const projectContents = configUtils.readProjectFile(projectFile);
        result.project.projectFile = path_1.default.relative(sourceDir, projectFile);
        // Add missing (auto) items
        result.project.projectName = configUtils.getProjectName(projectFile, projectContents);
        result.project.projectLang = configUtils.getProjectLanguage(projectFile);
        result.project.projectGuid = configUtils.getProjectGuid(projectContents);
        // Since we moved the UseExperimentalNuget property from the project to the
        // ExperimentalFeatures.props file, we should should double-check the project file
        // in case it was made with an older template
        const useExperimentalNuget = configUtils.tryFindPropertyValue(projectContents, 'UseExperimentalNuget');
        if (useExperimentalNuget) {
            result.experimentalFeatures = (_a = result.experimentalFeatures) !== null && _a !== void 0 ? _a : {};
            result.experimentalFeatures.UseExperimentalNuget = useExperimentalNuget;
        }
    }
    return result;
}
exports.projectConfigWindows = projectConfigWindows;
//# sourceMappingURL=projectConfig.js.map