import { invariant, ToNumber, ZERO } from '@formatjs/ecma402-abstract';
/**
 * http://ecma-international.org/ecma-402/7.0/index.html#sec-getoperands
 * @param s
 */
export function GetOperands(s) {
    invariant(typeof s === 'string', "GetOperands should have been called with a string");
    var n = ToNumber(s);
    invariant(n.isFinite(), 'n should be finite');
    var dp = s.indexOf('.');
    var iv;
    var f;
    var v;
    var fv = '';
    if (dp === -1) {
        iv = n;
        f = ZERO;
        v = 0;
    }
    else {
        iv = s.slice(0, dp);
        fv = s.slice(dp, s.length);
        f = ToNumber(fv);
        v = fv.length;
    }
    var i = ToNumber(iv).abs();
    var w;
    var t;
    if (!f.isZero()) {
        var ft = fv.replace(/0+$/, '');
        w = ft.length;
        t = ToNumber(ft);
    }
    else {
        w = 0;
        t = ZERO;
    }
    return {
        Number: n,
        IntegerDigits: i.toNumber(),
        NumberOfFractionDigits: v,
        NumberOfFractionDigitsWithoutTrailing: w,
        FractionDigits: f.toNumber(),
        FractionDigitsWithoutTrailing: t.toNumber(),
    };
}
