// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import React from 'react';
import Svg, {
    Ellipse,
    Path,
    Mask,
    G,
} from 'react-native-svg';

import type {StyleProp, ViewStyle} from 'react-native';

type Props = {
    theme: Theme;
    styles: StyleProp<ViewStyle>;
}

const TeamCommunicationSvg = ({theme, styles}: Props) => {
    return (
        <Svg
            width={253}
            height={208}
            viewBox='0 0 253 208'
            fill='none'
            style={styles}
        >
            <Ellipse
                cx={67.493}
                cy={90.6649}
                rx={66.4115}
                ry={66.2887}
                fill={theme.centerChannelBg}
            />
            <Path
                d='M67.493 157.454c36.953 0 66.911-29.902 66.911-66.79 0-36.886-29.958-66.788-66.911-66.788S.582 53.778.582 90.665s29.958 66.789 66.911 66.789z'
                stroke={theme.centerChannelColor}
                strokeOpacity={0.16}
            />
            <Ellipse
                cx={67.493}
                cy={90.6649}
                rx={66.4115}
                ry={66.2887}
                fill={theme.centerChannelColor}
                fillOpacity={0.16}
            />
            <Mask
                id='a'
                maskUnits='userSpaceOnUse'
            >
                <Ellipse
                    cx={67.493}
                    cy={90.6649}
                    rx={66.4115}
                    ry={66.2887}
                    fill='#fff'
                />
            </Mask>
            <G mask='url(#a)'>
                <Path
                    d='M39.256 77.027h18.43l.646-10.269c1.062-.315 3.468-2.393 4.15-2.673 2.864-1.147 5.923-17.056 5.011-19.363-1.163-2.58-9.269 1.354-13.325.064-3.734-1.19-8.63 3.762-8.853 9.402l-6.06 22.84z'
                    fill='#FFBC1F'
                />
                <Ellipse
                    cx={63.9032}
                    cy={51.2501}
                    rx={1.07694}
                    ry={1.07495}
                    fill='#6F370B'
                />
                <Path
                    d='M87.955 155.09c-7.675 2.795-15.96 4.315-24.605 4.315-4.954 0-9.793-.502-14.467-1.455-15.364-3.139-28.948-11.158-39.05-22.366-.179-5.382-.193-11.689.03-19.063 1.342-43.75 4.12-41.615 42.488-41.901 43.38-.323 37.45 17.937 38.01 33.309.358 9.789-.92 32.263-2.406 47.161z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M45.76 84.853c2.721 1.01 9.98.538 11.48-1.634 1.034-1.505 2.018-3.053 3.03-4.572.812-1.225 1.608-2.45 2.384-3.698-3.08-.243-6.498-.358-10.303-.33-5.083.036-9.527.036-13.44.1 3.748 4.143 1.644 8.206 6.85 10.134zM90.353 98.304c-1.343.093-2.664.301-3.906.51-6.39 1.081-2.9 3.152-2.663 26.701.122 11.903 2.204 18.69.947 30.579 0 .028-.014.05-.014.079a64.146 64.146 0 003.245-1.09c1.486-14.899 2.764-37.372 2.405-47.161-.115-3.147.043-6.414 0-9.625l-.014.007zM73.502 147.351c-.265 7.374-.983 6.163-7.086 2.2-4.703-3.053-12.622 4.464-24.18 6.7a71.825 71.825 0 01-25.819-14.246c-4.975-12.126-6.002-28.859-6.002-38.362 0-.953 22.566 1.226 22.566 1.226-.13 17.249 1.6 37.379 15.902 34.835 14.302-2.537 24.892.273 24.62 7.647z'
                    fill='#FFBC1F'
                />
                <Path
                    d='M131.722 109.985c-9.42 28.694-36.473 49.42-68.372 49.42-4.954 0-9.793-.502-14.467-1.455v-6.342h22.193s10.776-40.906 10.676-41.623h49.97z'
                    fill='#484D5B'
                />
                <Path
                    d='M105.129 109.985H81.752c.043.323-2.154 8.951-4.574 18.267 9.341-6.048 18.646-12.154 27.951-18.267zM92.75 127.199c6.319-3.927 12.651-7.833 19.013-11.688 2.864-1.735 5.636-3.662 8.443-5.526h-9.851c-11.394 7.489-22.788 14.971-34.24 22.374-.552 2.135-1.105 4.249-1.629 6.256 6.088-3.805 12.17-7.625 18.265-11.416z'
                    fill='#6C7389'
                />
                <Path
                    d='M70.408 38.981c-1.493-1.97-3.77-.516-6.146.165-5.018 2.129-11.401-1.505-16.04 1.355-3.553 2.185-4.17 6.994-4.422 11.157-.107 1.828.194 4.236 1.996 4.601.618.122 1.271-.057 1.881.086 1.723.395 1.932 2.716 1.917 4.48-.021 3.045.517 6.212 2.32 8.67 1.794 2.459 5.082 4.007 7.99 3.082 3.453-1.096 5.09-4.952 6.167-8.399.632-2.042 2.248-5.504.352-6.5-2.032-1.075-7.438 1.563-10.03-.193-1.759-1.197-1.658-3.777-1.364-5.884.201-1.447.452-2.995 1.472-4.042 1.637-1.69 4.365-1.325 6.72-1.246 2.147.078 4.437-.244 6.103-1.606 1.666-1.361 2.39-4.013 1.091-5.718l-.007-.008z'
                    fill='#6F370B'
                />
                <Path
                    d='M66.258 48.778a266.15 266.15 0 012.886 8.75c-.28 1.627-5.463-.043-5.463-.043l2.577-8.707zM52.538 48.778s-3.77-1.068-3.647 2.48c.122 3.547 4.25 2.773 4.25 2.773l-.596-5.253h-.007z'
                    fill='#FFBC1F'
                />
            </G>
            <Path
                d='M148.526 18.32H98.48a6.962 6.962 0 00-4.946 2.036 7.014 7.014 0 00-2.062 4.95v31.927a7.035 7.035 0 002.062 4.95 6.984 6.984 0 004.946 2.036h7.386v11.952l11.078-11.952h31.564a6.965 6.965 0 004.946-2.036 7.025 7.025 0 002.062-4.95V25.306a7.024 7.024 0 00-2.056-4.944 6.972 6.972 0 00-4.934-2.043z'
                fill='#FFBC1F'
            />
            <Path
                d='M116.944 64.22h31.564a6.965 6.965 0 004.946-2.037 7.024 7.024 0 002.062-4.95V37.85s-2.204 17.924-2.6 19.501c-.396 1.578-1.182 3.938-4.904 4.33-3.723.391-31.068 2.538-31.068 2.538z'
                fill='#CC8F00'
            />
            <Path
                d='M106.409 36.705c.892 0 1.763.266 2.505.763a4.522 4.522 0 011.66 2.03 4.543 4.543 0 01-.977 4.933 4.492 4.492 0 01-4.913.98 4.533 4.533 0 01-2.783-4.18 4.535 4.535 0 011.318-3.202 4.51 4.51 0 013.19-1.324zM123.503 36.705c.892 0 1.764.266 2.505.763a4.535 4.535 0 01.683 6.963 4.502 4.502 0 01-4.913.98 4.533 4.533 0 01-2.783-4.18 4.517 4.517 0 011.319-3.202 4.506 4.506 0 013.189-1.324zM140.579 36.705a4.495 4.495 0 012.506.76 4.522 4.522 0 011.663 2.03 4.545 4.545 0 01-.973 4.934 4.49 4.49 0 01-4.914.984 4.517 4.517 0 01-2.025-1.668 4.543 4.543 0 01.557-5.714 4.503 4.503 0 013.186-1.326z'
                fill={theme.centerChannelBg}
            />
            <Path
                d='M96.666 31.688a14.254 14.254 0 012.53-4.967 14.194 14.194 0 014.235-3.61.494.494 0 00-.2-.93c-3.156-.19-9.525.486-7.528 9.46a.5.5 0 00.463.403.495.495 0 00.5-.356z'
                fill='#FFD470'
            />
            <Ellipse
                cx={198.383}
                cy={150.952}
                rx={53.6174}
                ry={53.5182}
                fill={theme.centerChannelBg}
            />
            <Path
                d='M198.383 204.97c29.887 0 54.117-24.184 54.117-54.018 0-29.835-24.23-54.019-54.117-54.019-29.888 0-54.118 24.184-54.118 54.019 0 29.834 24.23 54.018 54.118 54.018z'
                stroke={theme.centerChannelColor}
                strokeOpacity={0.16}
            />
            <Ellipse
                cx={198.383}
                cy={150.952}
                rx={53.6174}
                ry={53.5182}
                fill={theme.centerChannelColor}
                fillOpacity={0.16}
            />
            <Mask
                id='b'
                maskUnits='userSpaceOnUse'
            >
                <Ellipse
                    cx={198.383}
                    cy={150.952}
                    rx={53.6174}
                    ry={53.5182}
                    fill='#fff'
                />
            </Mask>
            <G mask='url(#b)'>
                <Path
                    d='M210.875 125.784c-3.074 0-5.757.121-8.091.386-17.64 1.983-10.847 10.028-13.268 32.765-2.738 25.751-8.427 41.419 18.763 44.087 27.19 2.668 31.165-13.17 33.438-42.502 2.273-29.326-3.975-34.736-30.842-34.736z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M197.734 185.922s.014 6.945-2.067 14.057c-.499 1.715-1.118 3.436-1.9 5.069h-26.26a165.66 165.66 0 003.003-39.886c-.033-.861-1.387-.861-1.347 0a164.613 164.613 0 01-3.03 39.886h-22.207c.532-.497.128-44.256 13.296-60.075a18.558 18.558 0 013.623-3.368c9.174-6.481 15.741-3.94 21.324 4.417 1.192 1.781 2.337 3.825 3.455 6.111 2.425 4.961 4.715 11.025 7.025 17.876a584.942 584.942 0 013.22 9.93c.269.867.545 1.741.822 2.628.343 1.11.693 2.226 1.043 3.355z'
                    fill='#82889C'
                />
                <Path
                    d='M177.555 205.048h-11.423a164.563 164.563 0 003.031-39.886c-.04-.861 1.038-.807 1.347 0 4.857 12.666 9.652 26.77 7.045 39.886z'
                    fill='#3F4350'
                />
                <Path
                    d='M238.752 185.102c.324 7.435.768 14.877-.094 19.946H168.16c3.085-6.487 8.917-10.346 17.013-15.301 3.442-2.097 7.294-4.403 11.517-7.18.344-.235.694-.464 1.044-.699 0 0 .277-.128.782-.356 5.839-2.636 42.573-18.495 40.634.343v.013c-.115 1.123-.445 2.192-.398 3.234z'
                    fill='#A4A9B7'
                />
                <Path
                    d='M238.746 204.463c.734-5.048.316-12.202 0-19.361-.047-1.042.283-2.111.397-3.234v-.013c1.933-18.777-34.552-3.08-40.573-.37 10.002 12.787 24.119 21.607 40.169 22.978h.007z'
                    fill='#3F4350'
                />
                <Path
                    d='M202.936 126.362c-11.177.942-39.797-1.45-44.092 11.581-3.912 11.851 8.658 10.218 12.071 18.797 3.407 8.579 3.602 15.66 6.82 8.023 3.219-7.637-.592-17.361-2.194-21.555-1.596-4.195 12.482 8.579 21.261 4.005 8.779-4.574 6.134-20.851 6.134-20.851z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M160.343 135.237c-.639.857-1.157 1.788-1.5 2.834-3.907 11.801 8.648 10.175 12.058 18.717 3.403 8.542 3.598 15.593 6.812 7.989 3.215-7.604-.592-17.287-2.192-21.463-2.045-7.274-11.251-8.907-15.178-8.077z'
                    fill='#A37200'
                />
                <Path
                    d='M228.89 144.895c-.1-.845-.976-.772-.916.087 1.639 22.147-8.434 28.823-8.434 28.823 9.874-5.585 10.703-17.733 9.35-28.91zM190.175 137.256c-.447 2.401-1.53 5.579-1.333 8.096.072.907.604 1.732.689 2.666.151 1.562.355 5.033.276 6.616-.039.872 1.326-5.743.407-8.491-.873-2.612.387-5.756.906-8.519.157-.852-.788-1.213-.945-.361v-.007z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.64}
                />
                <Path
                    d='M189.745 173.227h-6.484c-.804 0-1.532-.473-1.827-1.199l-4.643-11.221c-.522-1.252.432-2.623 1.827-2.623h6.484c.803 0 1.532.473 1.827 1.198l4.643 11.221c.522 1.252-.433 2.624-1.827 2.624z'
                    fill={theme.centerChannelColor}
                />
                <Path
                    d='M222.202 126.369c20.056 1.498 25.161 7.51 25.161 30.04 0 35.031-20.789 38.181-36.466 31.108-15.677-7.067-24.335-13.415-27.29-18.957-2.384-4.467 2.902 0 8.98 1.216 1.525.302 2.909 1.135 4.319 1.518 31.939 8.679 36.164-4.305 34.337-19.614-1.827-15.309-9.035-25.318-9.035-25.318l-.006.007z'
                    fill='#A37200'
                />
                <Path
                    d='M222.249 126.362s5.42 8.321 7.251 23.638c1.254 10.527-5 22-10.068 23.677-.134 5.435-1.381 10.829-3.95 15.545 14.841 4.494 31.881-1.075 31.881-32.817 0-22.532-5.097-28.545-25.121-30.043h.007z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M154.275 202.801h-33.368a2.26 2.26 0 01-1.386-.663 2.309 2.309 0 01-.655-1.404v-43.883a2.3 2.3 0 01.658-1.421 2.268 2.268 0 011.404-.666h24.745l10.715 10.727v35.222c.006.264-.041.527-.138.773a1.926 1.926 0 01-.429.653c-.418.404-.968.64-1.546.662z'
                    fill='#000'
                    fillOpacity={0.2}
                />
            </G>
            <Path
                d='M202.252 119.598l5.813 10.236c4.396-.459 7.519-2.686 11.935-2.834-2.46-3.054-9.134-13.895-9.809-14.751-1.26-1.605.178-5.893-.627-7.269-2.889-5.036-10.555-2.117-12.307-1.692-1.696.405-4.961 2.414-4.961 2.414 1.172 3.756 3.687 9.736 7.081 14.112.572.742 1.69.351 2.875-.216z'
                fill='#A37200'
            />
            <Path
                d='M194.845 109.005c-.876 3.699-1.389 6.342-1.389 6.342.349 1.216 4.057.21 4.057.21l-2.668-6.552z'
                fill='#A37200'
            />
            <Path
                d='M202.5 119.5c.874-.481 1.389-.931 2.069-1.693.305-.348.569.104.451.555-.09.347-.569.873-1.201 1.183-.402.2-1.909.281-1.319-.045z'
                fill='#6F370B'
            />
            <Path
                d='M215.661 106.608c-.892-.782-2.043-1.403-2.472-2.498-.381-.982-.075-2.084-.279-3.112-.354-1.77-2.247-2.96-4.086-2.986-1.839-.026-6.872 1.884-8.826 1.937-1.955.047-3.923-.12-5.85.207-1.928.327-3.869 1.242-4.829 2.912-.96 1.67-.531 4.147 1.219 4.989 1.471.708 3.242.1 4.631-.748 1.39-.848 2.67-1.957 4.257-2.351 1.586-.394 3.63.307 3.929 1.883.17.902-.265 1.797-.402 2.705-.136.908.252 2.077 1.179 2.164 1.055.1 1.886-1.276 2.908-1.008.905.24.967 1.435 1.151 2.33.429 2.118 2.69 3.66 4.882 3.48 2.193-.18 4.1-1.943 4.591-4.054.49-2.11-.368-4.415-2.009-5.857l.006.007z'
                fill='#4A2407'
            />
            <Path
                d='M238.359 120.558c.744-1.516.724-3.045.724-4.703 0-.521.101-.968.27-1.367-.068-.44-.115-.887-.135-1.333-.088-1.848.419-3.871 1.886-4.995.643-.494 1.427-.792 1.981-1.374 1.089-1.157.906-3.011.393-4.513-1.015-2.978-3.084-5.604-5.782-7.221-2.697-1.618-6.017-2.2-9.087-1.516-1.684.372-3.266 1.103-4.936 1.536-1.67.433-3.53.535-5.037-.305-1.616-.893-6.559-2.422-8.405-2.504-16.532-.717-19.839 9.137-20.785 10.456-1.069 1.34 16.18-3.214 18.033-2.199 1.061-1.55.216 12.012 1.731 14.279 1.075 1.611 4.956 6.876 12.008 9.441 4.172.467 8.392.704 12.394-.44 1.373-.393 2.759-1.069 4.037-1.942.25-.42.494-.853.717-1.3h-.007z'
                fill='#4A2407'
            />
            <Path
                d='M211.404 133.302c4.77-.1 8.432-3.064 10.454-7.062-3.218-.329-6.88-.457-11.045-.457-3.077 0-5.745.128-8.083.39 1.532 3.938 3.675 7.237 8.667 7.129h.007z'
                fill='#A37200'
            />
            <Path
                d='M183.147 140.425a250.153 250.153 0 00-1.199 13.716c-.062 1.08 1.791.93 1.854-.134.267-4.431.655-8.853 1.166-13.268.118-1.067-1.694-1.39-1.821-.314zM198.094 147.776a72.644 72.644 0 01-7.577 8.737c-.765.75.344 2.01 1.109 1.259a76.024 76.024 0 007.851-9.07c.641-.869-.75-1.794-1.383-.926zM207.294 164.374c-3.906-.147-7.821-.303-11.727-.451-.899-.031-.769 1.652.123 1.693 3.906.148 7.821.304 11.727.451.899.032.769-1.652-.123-1.693z'
                fill='#FFBC1F'
            />
            <Path
                d='M198.4 118.479a6.115 6.115 0 001.969-.933c.244-.179-.012-.574-.26-.396-.605.44-1.29.752-2.014.923l.305.406z'
                fill='#4A2407'
            />
            <Ellipse
                cx={197.351}
                cy={110.709}
                rx={1.00127}
                ry={0.666278}
                transform='rotate(-13.871 197.351 110.709)'
                fill='#4A2407'
            />
            <G clipPath='url(#clip0_418_7357)'>
                <Path
                    d='M149.275 195.801h-33.368a2.26 2.26 0 01-1.386-.663 2.311 2.311 0 01-.655-1.404v-43.883a2.298 2.298 0 012.062-2.088h24.745l10.715 10.728v35.222c.006.264-.041.527-.138.772a1.92 1.92 0 01-.429.654 2.359 2.359 0 01-1.546.662z'
                    fill='#E8E9ED'
                />
                <Path
                    d='M136.061 155.075H118.53a.688.688 0 01-.5-.259.724.724 0 01-.153-.547c0-.475.219-.713.653-.713h17.531c.439 0 .658.238.658.713a.714.714 0 01-.658.806zm-2.72 5.127c.199 0 .39-.08.531-.223a.766.766 0 000-1.074.745.745 0 00-.531-.223h-14.796a.765.765 0 00-.667.76.765.765 0 00.667.76h14.796zm11.623 5.219a.753.753 0 00.812-.757.778.778 0 00-.242-.559.741.741 0 00-.57-.198H118.53a.753.753 0 00-.464.256.77.77 0 00.464 1.258h26.434zm-1.684 5.131c.432 0 .682-.253.75-.759a.826.826 0 00-.235-.522.807.807 0 00-.515-.238h-24.75a.688.688 0 00-.5.259.729.729 0 00-.153.547c0 .475.219.713.653.713h24.75zm-9.939 5.219c.199 0 .39-.08.531-.222a.768.768 0 000-1.074.745.745 0 00-.531-.223h-14.796a.766.766 0 00-.667.76.765.765 0 00.667.759h14.796zm11.623 5.127c.439 0 .689-.254.75-.76a.817.817 0 00-.234-.522.804.804 0 00-.516-.238H118.53a.704.704 0 00-.633.517.723.723 0 00-.02.289c0 .476.219.714.653.714h26.434zm0 5.224a.81.81 0 00.515-.239.826.826 0 00.235-.521.816.816 0 00-.233-.523.795.795 0 00-.517-.236H118.53a.75.75 0 00-.477.251.77.77 0 000 1.017c.123.14.293.229.477.251h26.434zm0 5.126c.439 0 .689-.253.75-.76a.7.7 0 00-.232-.498.695.695 0 00-.518-.168H118.53c-.434 0-.653.238-.653.713s.219.713.653.713h26.434z'
                    fill='#989DAE'
                />
                <Path
                    d='M140.653 147.763l10.587 10.728h-8.342a2.219 2.219 0 01-1.592-.615 2.162 2.162 0 01-.659-1.664l.006-8.449z'
                    fill='#BABEC9'
                />
            </G>
            <Path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M161.915 54.431a1.5 1.5 0 011.626-1.362c4.754.418 12.243 3.2 19.554 7.49 6.326 3.711 12.707 8.66 17.203 14.432l2.18-9.876a1.501 1.501 0 012.93.647l-2.91 13.182a1.501 1.501 0 01-1.789 1.141l-13.182-2.91a1.5 1.5 0 11.647-2.93l9.339 2.063c-4.155-5.145-9.993-9.675-15.936-13.162-7.141-4.189-14.182-6.726-18.3-7.089a1.5 1.5 0 01-1.362-1.626zM102.839 185.763a1.5 1.5 0 01-1.439 1.559c-4.086.162-10.71-1.381-17.324-4.201-5.578-2.377-11.338-5.741-15.723-9.971l-.909 10.107a1.5 1.5 0 01-2.987-.268l1.209-13.446a1.5 1.5 0 011.628-1.36l13.446 1.209a1.501 1.501 0 01-.269 2.988l-9.463-.851c3.957 3.641 9.106 6.642 14.244 8.833 6.433 2.742 12.581 4.099 16.029 3.962a1.5 1.5 0 011.558 1.439z'
                fill={theme.centerChannelColor}
                fillOpacity={0.32}
            />
        </Svg>
    );
};

export default TeamCommunicationSvg;
