// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import React from 'react';
import Svg, {
    Ellipse,
    Path,
    Mask,
    G,
} from 'react-native-svg';

import type {StyleProp, ViewStyle} from 'react-native';

type Props = {
    theme: Theme;
    styles: StyleProp<ViewStyle>;
};

const CallsSvg = ({theme, styles}: Props) => {
    return (
        <Svg
            width={284}
            height={191}
            viewBox='0 0 284 191'
            fill='none'
            style={styles}
        >
            <Ellipse
                cx={129.562}
                cy={116.733}
                rx={72.9374}
                ry={72.8026}
                fill={theme.centerChannelBg}
            />
            <Path
                d='M129.562 190.036c40.558 0 73.438-32.818 73.438-73.303 0-40.484-32.88-73.302-73.438-73.302-40.557 0-73.437 32.818-73.437 73.302 0 40.485 32.88 73.303 73.437 73.303z'
                stroke={theme.centerChannelColor}
                strokeOpacity={0.16}
            />
            <Ellipse
                cx={129.562}
                cy={116.733}
                rx={72.9374}
                ry={72.8026}
                fill={theme.centerChannelColor}
                fillOpacity={0.16}
            />
            <Mask
                id='a'
                maskUnits='userSpaceOnUse'
            >
                <Ellipse
                    cx={129.562}
                    cy={116.733}
                    rx={72.9374}
                    ry={72.8026}
                    fill='#fff'
                />
            </Mask>
            <G mask='url(#a)'>
                <Path
                    d='M89.869 169.039c-.092 8.613.367 15.76 1.344 21.675a109.548 109.548 0 0013.337 4.419c.102.03.193.051.295.081.468.122.937.244 1.415.356a103.56 103.56 0 008.99 1.853 113.578 113.578 0 0018.539 1.507c19.089 0 37.069-4.683 52.869-12.98a110.39 110.39 0 0014.182-8.817c.947-12.787 4.011-32.334 4.215-46.343.835-56.412 1.578-61.767-38.789-63.763a987.79 987.79 0 00-12.268-.509c-5.64-.204-10.792-.336-15.495-.367-2.474-.02-4.826 0-7.055.051-18 .377-28.262 2.973-34.096 10.344-5.834 7.381-7.218 19.517-7.473 38.993-.122 9.152 0 19.924.04 32.599.011 2.983.011 6.068 0 9.244 0 3.736-.01 7.615-.05 11.657z'
                    fill={theme.buttonBg}
                />
                <Path
                    d='M89.869 169.039c-.092 8.613.367 15.76 1.344 21.675a109.994 109.994 0 0013.632 4.5c0-52.757-1.14-71.754-.713-77.018-1.435-.509-5.08-1.364-14.253-2.657-.122 9.152 0 19.924.04 32.599.011 2.983.011 6.068 0 9.244 0 3.736-.01 7.615-.05 11.657z'
                    fill='#A37200'
                />
                <Path
                    d='M94.97 137.279l21.483 1.098c2.292.122 3.627-2.538 2.157-4.295l-21.287-25.397a3.435 3.435 0 00-2.463-1.22l-18.137-.928c-2.99-.159-4.742 3.32-2.818 5.614l21.066 25.128z'
                    fill='#3F4350'
                />
                <Path
                    d='M176.936 133.152c2.983-4.908 20.891-1.426 21.115-1.385.722.458 6.006 1.731 6.933 1.995-.183 3.126-.346 9.357-1.334 16.096-1.751 7.728-4.184 16.442-7.513 26.267a74.069 74.069 0 01-2.057 5.335c-3.685 1.7-7.228 4.204-10.883 5.518-1.731.621-9.743-48.105-6.261-53.816v-.01z'
                    fill='#000'
                    fillOpacity={0.5}
                />
                <Path
                    d='M87.544 130.025c1.364 2.372 3.594 5.243 7.035 7.747 14.071 10.208 35.139 53.326 55.948 53.326 19.089 0 32.422-13.325 48.222-21.622 1.823-3.279 3.452-6.964 4.857-11.087 5.833-17.196 8.928-31.062 10.415-42.017-5.05-1.211-26.471-8.297-30.523-10.303-14.192 68.884-26.796 68.13-49.611 48.756-25.472-21.634-24.047-20.076-36.345-24.8a135.815 135.815 0 01-2.963-1.181c-9.651-3.991-11.117-5.946-7.035 1.181z'
                    fill='#CC8F00'
                />
                <Path
                    d='M171.051 123.49l.723-1.894-3.421-1.323 1.965-11.423-2.006-.346-2.239 13.072 4.978 1.914zM103.114 100.054h2.036v18.142h-2.036v-18.142z'
                    fill='#000'
                    fillOpacity={0.5}
                />
                <Path
                    d='M130.209 89.272a8 8 0 018-8h88.335a8 8 0 018 8v41.11a8 8 0 01-8 8h-96.335v-49.11z'
                    fill='#000'
                    fillOpacity={0.32}
                />
            </G>
            <Path
                d='M154.112 57.464a224.48 224.48 0 01-4.261-5.57c-2.497-3.404-4.958-7.016-6.868-10.346-.919-1.604-.796-3.98-.368-6.514-2.742-6.195-5.191-12.513-7.162-19.002-7.53-2.633-17.105-.588-19.994-.306-4.151.391-7.897.44-8.84 3.575-1.322 4.444 1.383 13.174 2.865 21.794l10.75 12.586 8.424 15.892 3.722 4.714 31.944-3.746s-6.208-8.032-10.212-13.089v.012z'
                fill='#CC8F00'
            />
            <Path
                d='M108.419 27.761c-3.416 9.06-5.571 15.586-5.571 15.586.379 3.196 9.489 1.898 9.489 1.898l-3.918-17.484z'
                fill='#CC8F00'
            />
            <Path
                d='M132.845 1.217c5.473 1.885 10.187 5.742 13.456 10.517 4.126 6.012 6.011 13.53 5.24 20.778-.367 3.452-1.445 7.028-4.053 9.317-2.852 2.51-7.334 2.926-10.652 1.065-3.318-1.86-5.289-5.815-4.873-9.599.282-2.595 1.58-5.069 1.408-7.677-.183-2.607-3.073-5.252-5.228-3.783-1.763 1.2-1.677 4.26-3.648 5.081-2.51 1.053-4.224-2.534-6.306-4.297-3.244-2.743-8.093-.894-12.195.232-5.73 1.58-12.353 1.25-17.006-2.448-4.653-3.698-6.232-11.35-2.228-15.746C89.282 1.89 93.347.96 97.069 1.364c6.697.722 9.709 4.37 16.21 1.567 6.355-2.755 12.783-4.053 19.554-1.727l.012.013z'
                fill='#4A2407'
            />
            <Path
                d='M126.356 65.986c7.934-.184 17.116-.012 27.781.38 5.118.183 9.807.367 14.117.575 0 17.692-47.702 33.021-41.886-.955h-.012zM106.491 25.547c1.074 7.99 4.058 20.918 9.262 30.88 1.064 2.038 4.179 1.005 7.222 0 10.972-3.601-16.484-30.88-16.484-30.88z'
                fill='#CC8F00'
            />
            <Path
                d='M113.306 50.358c1.968-.112 4.273-1.242 5.723-2.473.744-.336.288-1.523-.467-1.191-2.082 1.63-3.829 2.372-5.837 2.422l.581 1.242z'
                fill='#6F370B'
            />
            <Ellipse
                rx={1.83656}
                ry={1.22437}
                transform='scale(-1 1) rotate(20.516 -144.81 -296.006)'
                fill='#6F370B'
            />
            <Path
                d='M122.454 56.635c2.179-.76 4.175-2.339 5.975-3.771.82-.65 1.285.416.869 1.359-.318.735-1.604 1.714-3.159 2.18-.991.293-5.167.734-3.697.22l.012.012z'
                fill='#A37200'
            />
            <Path
                d='M119.226 83.78a8 8 0 018-8h148.74a8 8 0 018 8v38.914a8 8 0 01-8 8h-156.74V83.78z'
                fill='#fff'
            />
            <Path
                d='M119.726 83.78a7.5 7.5 0 017.5-7.5h148.74a7.5 7.5 0 017.5 7.5v38.914a7.5 7.5 0 01-7.5 7.5h-156.24V83.78z'
                stroke={theme.centerChannelColor}
                strokeOpacity={0.16}
            />
            <Ellipse
                cx={151.076}
                cy={103.237}
                rx={18.6705}
                ry={18.6705}
                fill='#30916B'
            />
            <Path
                d='M145.075 101.684a17.227 17.227 0 003.079 4.181 17.57 17.57 0 004.279 3.009l2.452-2.397c.313-.306.696-.391 1.148-.255 1.252.408 2.574.612 3.965.612.314 0 .574.102.783.306.209.204.313.459.313.765v3.824c0 .306-.104.561-.313.765a1.075 1.075 0 01-.783.306c-2.504 0-4.922-.459-7.252-1.377a19.005 19.005 0 01-6.157-4.028 18.508 18.508 0 01-4.123-6.017 18.427 18.427 0 01-1.408-7.088c0-.306.104-.561.313-.765.208-.204.469-.306.782-.306h3.914c.313 0 .574.102.782.306.209.204.313.459.313.764 0 1.36.209 2.652.627 3.876.139.442.052.816-.261 1.122l-2.453 2.397z'
                fill='#fff'
            />
            <Path
                d='M181.178 99.269h4.942v1.592h-6.678v-9.618h1.736v8.026zm9.26.246c.337 0 .683-.069 1.039-.206.355-.136.633-.31.834-.519l1.08 1.121c-.31.328-.745.597-1.306.807-.556.209-1.1.314-1.634.314a3.83 3.83 0 01-1.893-.478 3.652 3.652 0 01-1.374-1.36 3.843 3.843 0 01-.513-1.97c0-1.075.353-1.97 1.06-2.686.711-.72 1.583-1.08 2.618-1.08 1.112 0 1.98.392 2.604 1.176.629.779.944 1.843.944 3.192h-5.462c.109.506.342.914.697 1.224.36.31.795.465 1.306.465zm-.014-4.546c-.474 0-.891.141-1.251.424a2.073 2.073 0 00-.725 1.127h3.808c-.105-.474-.312-.85-.622-1.127-.31-.283-.713-.424-1.21-.424zm9.957 5.55a3.815 3.815 0 01-1.928.513 3.815 3.815 0 01-1.928-.513 3.93 3.93 0 01-1.421-1.394 3.596 3.596 0 01-.527-1.887c0-.674.176-1.3.527-1.88a3.88 3.88 0 011.421-1.387 3.817 3.817 0 011.928-.513c.688 0 1.331.17 1.928.513a3.883 3.883 0 011.422 1.387 3.53 3.53 0 01.533 1.88c0 .675-.178 1.304-.533 1.887a3.932 3.932 0 01-1.422 1.394zm-1.928-.943c.597 0 1.112-.23 1.545-.69a2.322 2.322 0 00.656-1.648 2.29 2.29 0 00-.656-1.634c-.433-.46-.948-.69-1.545-.69-.601 0-1.121.23-1.558.69a2.305 2.305 0 00-.65 1.634c0 .638.217 1.187.65 1.648.437.46.957.69 1.558.69zm8.891-6.118c.788 0 1.433.262 1.934.786.502.52.752 1.19.752 2.01v4.607h-1.654v-4.272c0-.488-.144-.889-.431-1.203-.282-.315-.647-.472-1.093-.472-.447 0-.837.132-1.169.397-.333.26-.527.583-.581.97v4.58h-1.709v-7.239h1.709v.964c.227-.342.542-.615.943-.82a2.812 2.812 0 011.299-.308zm7.27 0c.953 0 1.709.278 2.27.834.56.556.841 1.294.841 2.215v4.354h-1.668v-.868c-.26.328-.597.583-1.012.766a3.138 3.138 0 01-1.272.273c-.779 0-1.424-.212-1.934-.636-.511-.423-.766-.982-.766-1.674 0-.702.285-1.279.855-1.73.569-.456 1.269-.684 2.098-.684.67 0 1.347.133 2.031.397v-.198c0-.219-.032-.424-.096-.616a1.63 1.63 0 00-.294-.526 1.311 1.311 0 00-.554-.376 2.32 2.32 0 00-.834-.136c-.579 0-1.233.182-1.962.546l-.588-1.19c1.017-.5 1.978-.751 2.885-.751zm-.465 6.323c.442 0 .846-.105 1.21-.314.369-.215.602-.506.698-.875v-.814a5.39 5.39 0 00-1.778-.28c-.433 0-.797.11-1.094.328-.296.219-.444.497-.444.834 0 .337.132.609.397.814.264.205.601.307 1.011.307zm6.751-4.758a2.71 2.71 0 011.032-1.148c.452-.278.971-.417 1.559-.417v1.456c-.775 0-1.401.21-1.88.629-.474.42-.711.973-.711 1.661v3.657h-1.709v-7.239h1.709v1.401zm8.939-3.95h1.709v9.788h-1.709v-1.12a3.012 3.012 0 01-1.08.956 3.039 3.039 0 01-1.429.335c-.962 0-1.755-.353-2.379-1.06-.624-.71-.937-1.622-.937-2.734 0-1.103.313-2.007.937-2.714.624-.71 1.417-1.066 2.379-1.066 1.066 0 1.903.428 2.509 1.285v-3.67zm-2.044 8.503c.601 0 1.091-.219 1.469-.656.383-.438.575-.998.575-1.682 0-.679-.192-1.235-.575-1.668-.378-.437-.868-.656-1.469-.656-.611 0-1.112.219-1.504.656-.388.433-.581.99-.581 1.668 0 .68.196 1.24.588 1.682.392.437.891.656 1.497.656zm-45.653 15.456a5.189 5.189 0 01-1.682-.287 4.793 4.793 0 01-1.476-.807l.765-1.189c.775.561 1.582.841 2.42.841.347 0 .627-.069.841-.205.214-.137.321-.317.321-.54a.603.603 0 00-.048-.246.461.461 0 00-.15-.206 1.815 1.815 0 00-.212-.15 1.384 1.384 0 00-.307-.137 5 5 0 00-.342-.116 12.678 12.678 0 00-.397-.109c-.428-.11-.786-.219-1.073-.328a3.905 3.905 0 01-.786-.41 1.562 1.562 0 01-.533-.588 1.902 1.902 0 01-.178-.821c0-.679.253-1.228.759-1.647.506-.419 1.162-.629 1.968-.629.976 0 1.901.289 2.776.868l-.718 1.244c-.693-.437-1.378-.656-2.058-.656-.309 0-.565.059-.765.178-.201.114-.301.269-.301.465 0 .218.096.385.287.499.196.109.595.25 1.196.423.21.06.386.112.527.158.141.041.307.1.499.177a2.897 2.897 0 01.889.513c.141.114.252.237.334.369.083.132.151.29.206.472.054.178.082.371.082.581 0 .693-.262 1.246-.787 1.661-.519.415-1.205.622-2.057.622zm7.523-1.722l.486 1.148a2.291 2.291 0 01-.718.417 2.277 2.277 0 01-.821.157c-.601 0-1.093-.196-1.476-.588-.378-.392-.567-.893-.567-1.504v-3.903h-1.053v-1.415h1.053v-1.989h1.667v1.989h1.634v1.415h-1.634v3.698c0 .246.067.449.199.609a.653.653 0 00.512.232c.301 0 .54-.089.718-.266zm4.543-5.852c.953 0 1.709.278 2.27.834.56.556.84 1.294.84 2.215v4.354h-1.668v-.868a2.602 2.602 0 01-1.011.766 3.138 3.138 0 01-1.272.273c-.779 0-1.424-.212-1.934-.636-.511-.423-.766-.982-.766-1.674 0-.702.285-1.279.855-1.73.569-.456 1.269-.683 2.098-.683.67 0 1.347.132 2.03.396v-.198c0-.219-.031-.424-.095-.615a1.633 1.633 0 00-.294-.527 1.315 1.315 0 00-.554-.376 2.321 2.321 0 00-.834-.137c-.579 0-1.233.183-1.962.547l-.588-1.189c1.017-.501 1.978-.752 2.885-.752zm-.465 6.323c.442 0 .846-.105 1.21-.314.369-.214.602-.506.697-.875v-.814a5.376 5.376 0 00-1.777-.28c-.433 0-.797.109-1.094.328-.296.219-.444.497-.444.834a.98.98 0 00.397.814c.264.205.601.307 1.011.307zm6.751-4.758c.237-.487.581-.87 1.032-1.148.452-.278.971-.417 1.559-.417v1.456c-.775 0-1.401.21-1.88.629-.474.419-.711.973-.711 1.661v3.657h-1.709v-7.239h1.709v1.401zm7.052 4.287l.485 1.148a2.27 2.27 0 01-.718.417 2.268 2.268 0 01-.82.157c-.601 0-1.094-.196-1.476-.588-.379-.392-.568-.893-.568-1.504v-3.903h-1.053v-1.415h1.053v-1.989h1.668v1.989h1.634v1.415h-1.634v3.698c0 .246.066.449.198.609a.656.656 0 00.513.232c.301 0 .54-.089.718-.266zm4.768.205c.338 0 .684-.069 1.039-.205.356-.137.634-.31.834-.52l1.08 1.121c-.309.328-.745.597-1.305.807a4.628 4.628 0 01-1.634.314 3.837 3.837 0 01-1.894-.478 3.648 3.648 0 01-1.374-1.361 3.851 3.851 0 01-.512-1.968c0-1.076.353-1.971 1.059-2.687.711-.72 1.584-1.08 2.618-1.08 1.112 0 1.981.392 2.605 1.176.629.779.943 1.843.943 3.192h-5.462c.11.506.342.914.698 1.224.36.31.795.465 1.305.465zm-.013-4.546c-.474 0-.891.141-1.251.424-.356.278-.597.653-.725 1.127h3.808c-.105-.474-.313-.849-.622-1.127-.31-.283-.714-.424-1.21-.424zm10.032-3.897h1.709v9.789h-1.709v-1.121a3.01 3.01 0 01-1.08.957 3.039 3.039 0 01-1.429.335c-.962 0-1.755-.353-2.379-1.059-.624-.711-.936-1.623-.936-2.735 0-1.103.312-2.007.936-2.714.624-.711 1.417-1.066 2.379-1.066 1.066 0 1.903.428 2.509 1.285v-3.671zm-2.044 8.504c.601 0 1.091-.219 1.47-.656.382-.438.574-.998.574-1.682 0-.679-.192-1.235-.574-1.668-.379-.437-.869-.656-1.47-.656-.611 0-1.112.219-1.504.656-.387.433-.581.989-.581 1.668 0 .679.196 1.24.588 1.682.392.437.891.656 1.497.656zm11.95-6.118c.952 0 1.709.278 2.269.834.561.556.841 1.294.841 2.215v4.354h-1.668v-.868a2.61 2.61 0 01-1.011.766 3.138 3.138 0 01-1.272.273c-.779 0-1.424-.212-1.935-.636-.51-.423-.765-.982-.765-1.674 0-.702.285-1.279.854-1.73.57-.456 1.27-.683 2.099-.683.67 0 1.347.132 2.03.396v-.198c0-.219-.032-.424-.095-.615a1.633 1.633 0 00-.294-.527 1.321 1.321 0 00-.554-.376 2.321 2.321 0 00-.834-.137c-.579 0-1.233.183-1.962.547l-.588-1.189c1.016-.501 1.978-.752 2.885-.752zm-.465 6.323c.442 0 .845-.105 1.21-.314.369-.214.602-.506.697-.875v-.814a5.38 5.38 0 00-1.777-.28c-.433 0-.798.109-1.094.328-.296.219-.444.497-.444.834 0 .337.132.608.396.814.265.205.602.307 1.012.307zm12.032 1.251a3.803 3.803 0 01-1.921-.513 3.955 3.955 0 01-1.415-1.394 3.594 3.594 0 01-.212-3.343c.21-.465.488-.866.834-1.203a3.943 3.943 0 011.244-.813 3.75 3.75 0 011.497-.308c.534 0 1.037.105 1.511.314.474.21.887.497 1.237.862l-1.148 1.005a2.251 2.251 0 00-.731-.527 2.09 2.09 0 00-.882-.198c-.593 0-1.105.23-1.538.69a2.317 2.317 0 00-.643 1.634c0 .638.214 1.187.643 1.648.433.46.945.69 1.538.69a2.252 2.252 0 001.654-.759l1.149.992c-.766.815-1.705 1.223-2.817 1.223zm6.888-7.574c.952 0 1.709.278 2.269.834.561.556.841 1.294.841 2.215v4.354h-1.668v-.868c-.26.328-.597.583-1.012.766a3.13 3.13 0 01-1.271.273c-.779 0-1.424-.212-1.935-.636-.51-.423-.765-.982-.765-1.674 0-.702.285-1.279.854-1.73.57-.456 1.269-.683 2.099-.683.67 0 1.347.132 2.03.396v-.198c0-.219-.032-.424-.096-.615a1.597 1.597 0 00-.294-.527 1.311 1.311 0 00-.553-.376 2.321 2.321 0 00-.834-.137c-.579 0-1.233.183-1.962.547l-.588-1.189c1.016-.501 1.978-.752 2.885-.752zm-.465 6.323c.442 0 .845-.105 1.21-.314.369-.214.601-.506.697-.875v-.814a5.38 5.38 0 00-1.777-.28c-.433 0-.798.109-1.094.328-.296.219-.444.497-.444.834 0 .337.132.608.396.814.264.205.602.307 1.012.307zm5.001 1.08v-9.789h1.709v9.789h-1.709zm3.175 0v-9.789h1.709v9.789h-1.709z'
                fill='#3F4350'
            />
            <G opacity={0.8}>
                <Path
                    d='M36.005 54.206a5.95 5.95 0 01-.895 3.508 5.71 5.71 0 01-1.588 1.62L26.33 65.29a.728.728 0 01-.914 0l-7.231-5.957a5.33 5.33 0 01-1.629-1.66 5.868 5.868 0 01-.874-3.747 5.842 5.842 0 011.834-3.656 5.628 5.628 0 013.748-1.502c1.497 0 2.828.567 3.994 1.702a.807.807 0 00.575.245.795.795 0 00.576-.245c1.214-1.189 2.618-1.75 4.212-1.684 1.594.066 2.959.748 4.093 2.047a5.81 5.81 0 011.29 3.373z'
                    fill='#FFBC1F'
                />
                <Path
                    d='M25.416 65.288a.728.728 0 00.914 0l7.192-5.957a5.708 5.708 0 001.588-1.62 5.95 5.95 0 00.895-3.507c.295 3.128-10.59 11.084-10.59 11.084z'
                    fill='#CC8F00'
                />
                <Path
                    d='M18.614 56.234a7.045 7.045 0 01.572-2.65c.36-.837.88-1.592 1.528-2.223a.243.243 0 00-.056-.39.233.233 0 00-.147-.023c-1.485.302-4.354 1.405-2.345 5.381a.239.239 0 00.11.108.232.232 0 00.28-.06.244.244 0 00.058-.143z'
                    fill='#FFD470'
                />
            </G>
            <Path
                d='M47.808 32.236c-.427-.574-.775-.68-1.401-.47-.246.208-.581.307-.775.574l-.076.072c-.131.232-.368.383-.478.636-.194.442-.55.574-1.027.649-.74.103-1.43.373-1.884 1.028-.042.046-.058.113-.116.146.047-.054.081-.117.124-.173.275-.401.635-.74 1.055-.99.42-.25.89-.408 1.379-.461.267-.036.527-.092.517-.448-.106-.09-.07-.214-.083-.327-.194-1.712-.05-3.43-.072-5.145 0-.513-.122-.958-.668-1.168-.498-.017-.727.285-.841.708a1.893 1.893 0 00-.055.29c.023-.293.01-.588-.038-.877-.138-.155-.066-.349-.095-.525-.082-.488-.326-.787-.859-.785-.604.155-.775.624-.794 1.149-.025.687-.083 1.37-.093 2.056-.017 1.046-.08 2.106.424 3.102-.172-.079-.527.325-.498-.167.091-1.455-.013-2.912.097-4.367a1.819 1.819 0 00-.194-1.12c-.168-.063-.333-.165-.519-.052-.754.417-.849 1.116-.785 1.86.036.433.017.87-.056 1.3a6.043 6.043 0 00-.075.79c0-.302.011-.605 0-.908-.018-.484.089-1.016-.26-1.45-.174 0-.333-.192-.521-.049a1.823 1.823 0 00-.514.914c-.141 1.01-.44 2-.494 3.025-.107 1.76.096 3.524.6 5.215.303 1.002.873 1.668 1.82 2.003 1.188.421 2.4.643 3.56-.119a11.42 11.42 0 012.228-3.367 3.11 3.11 0 00.581-.872c.173-.48.347-.957.72-1.34.09-.09.204-.18.166-.337zm-4.48-4.316c.021-.191.046-.383.062-.587-.004.144.004.289.023.432.054.282.059.57.014.852-.208.94-.082 1.858.178 2.786-.322 0-.506-.051-.416-.427.073-.346.093-.7.06-1.053a10.992 10.992 0 01.079-2.003zm-3.654 3.918c-.037.015-.062.03-.085.015a.718.718 0 00.238-.574c.027-.557.072-1.113.09-1.67-.01.462.047.923.167 1.37.171.616.185.61-.41.859z'
                fill='#FFBC1F'
            />
            <Path
                d='M44.299 26.155c-.645.274-.892.781-.75 1.603.047.446.03.898-.048 1.34-.084.766-.068 1.56.32 2.284.036.07.055.151.106.287l-1.081-.27c.387-.624.244-1.296.25-1.943.013-1.062.103-2.122.269-3.17a.798.798 0 01.934-.131z'
                fill='#CC8F00'
            />
            <Path
                d='M46.926 33.911c-.04-.73.405-1.21.882-1.675.219.192.09.366-.022.525-.277.39-.571.767-.86 1.15z'
                fill='#FFD470'
            />
            <Path
                d='M45.215 32.646a.466.466 0 00-.093.15c-.081.242-.271.284-.51.32-1.073.162-2.007.562-2.518 1.596a.453.453 0 00-.194.457l.283-.352c.535-.65 1.25-.936 2.07-1.028.224-.027.542.017.637-.213 0 0 1.054-1.512 1.984-1.914.006.007-.922-.123-1.659.984z'
                fill='#CC8F00'
            />
            <Path
                d='M43.993 38.097c-1.163.666-2.347.442-3.504 0-.606-.234-1.162-.594-1.406-1.237a13.502 13.502 0 01-.525-7.64c.137-.63.164-1.29.484-1.864a.563.563 0 01.62-.192.689.689 0 00-.918.178l-.031.035a1.923 1.923 0 00-.299.62c-.339.992-.434 2.032-.494 3.064-.08 1.353-.108 2.718.322 4.02a6.36 6.36 0 01.387 1.955 1.187 1.187 0 00.582 1.055 5.298 5.298 0 003.204.944c.688-.025 1.357-.203 1.7-.898-.033-.006-.101-.053-.122-.04z'
                fill='#CC8F00'
            />
            <Path
                d='M41.357 25.62s-.542-.418-1.226.217a1.158 1.158 0 00-.337.69c-.043.21-.09.423-.134.633.194 1.08.132 2.168.058 3.255-.04.592.194 1.281-.552 1.68.432-.102.812-.232 1.195-.35.157-.047.27-.093.132-.265-.45-.553-.387-1.22-.426-1.865-.037-.574.23-1.13.159-1.69-.09-.698-.085-1.352.265-1.915.08-.129.395-.533.866-.39zM42.981 25.148a.938.938 0 00-.996-.163.81.81 0 00-.116.054 1.79 1.79 0 00-.506.574 20.16 20.16 0 010 2.652c-.035.45-.044.901-.025 1.352.056.643.14 1.296-.271 1.962.432-.2.862-.017 1.244-.268a1.821 1.821 0 01-.547-1.064c-.217-1.314-.011-2.618-.019-3.925a1.53 1.53 0 01.403-1.15c.114-.1.397-.271.833-.024z'
                fill='#CC8F00'
            />
            <Path
                d='M49.131 32.573c.372.383.546.858.719 1.34.143.32.34.615.581.872.94.984 1.695 2.125 2.23 3.371 1.163.766 2.374.54 3.561.119.948-.335 1.518-1.002 1.822-2.003a15.02 15.02 0 00.597-5.215c-.053-1.025-.351-2.015-.492-3.026a1.836 1.836 0 00-.514-.913c-.194-.14-.347.046-.523.048-.349.435-.242.967-.26 1.451-.011.303 0 .605 0 .908a6.06 6.06 0 00-.077-.79 5.31 5.31 0 01-.056-1.301c.065-.743-.03-1.442-.776-1.86-.193-.112-.352-.01-.52.053a1.83 1.83 0 00-.194 1.12c.108 1.455 0 2.912.095 4.367.03.492-.324.088-.496.167.503-1 .441-2.057.424-3.102-.012-.686-.068-1.37-.095-2.056-.02-.527-.194-.996-.793-1.15-.532 0-.775.297-.86.786-.029.176.045.37-.093.524-.049.29-.062.584-.039.877a2.171 2.171 0 00-.054-.289c-.114-.423-.343-.726-.84-.708-.547.208-.662.654-.67 1.168-.02 1.723.125 3.433-.071 5.144-.014.113.023.238-.083.328-.012.356.25.411.517.448.488.053.958.21 1.377.461.42.25.78.588 1.055.99.044.056.077.119.126.172-.06-.032-.074-.1-.117-.145-.453-.655-1.145-.925-1.885-1.028-.476-.065-.825-.207-1.027-.65-.11-.244-.345-.403-.476-.635l-.076-.073c-.205-.262-.533-.362-.775-.574-.634-.209-.969-.096-1.403.47-.044.154.074.244.161.334zm4.394-2.65c-.031.352-.01.707.062 1.053.09.383-.095.433-.418.427.262-.928.387-1.846.18-2.786-.045-.282-.04-.57.014-.852.018-.143.025-.288.021-.432.017.191.04.394.064.587.086.664.112 1.335.077 2.003zm3.166 1.051c.12-.446.176-.907.165-1.369.021.557.064 1.113.093 1.67a.7.7 0 00.239.574c-.026.016-.049 0-.086-.015-.597-.245-.581-.24-.41-.86z'
                fill='#FFBC1F'
            />
            <Path
                d='M52.477 26.155c.645.274.89.781.75 1.603-.048.446-.032.898.047 1.34.085.766.07 1.56-.318 2.284a2.23 2.23 0 00-.107.287l1.081-.27c-.387-.624-.244-1.296-.25-1.943a22.367 22.367 0 00-.269-3.178.798.798 0 00-.934-.123z'
                fill='#CC8F00'
            />
            <Path
                d='M49.85 33.911c.04-.73-.405-1.21-.884-1.675-.218.192-.089.366.024.525.277.39.571.767.86 1.15z'
                fill='#FFD470'
            />
            <Path
                d='M51.56 32.646c.04.044.072.094.094.15.081.242.271.284.507.32 1.076.162 2.01.562 2.52 1.596a.448.448 0 01.183.457l-.282-.352c-.533-.65-1.248-.936-2.068-1.028-.225-.027-.542.017-.64-.213 0 0-1.051-1.512-1.983-1.914.004.007.934-.123 1.67.984z'
                fill='#CC8F00'
            />
            <Path
                d='M52.783 38.097c1.163.666 2.347.442 3.504 0 .606-.234 1.162-.594 1.406-1.237a13.518 13.518 0 00.523-7.64c-.137-.63-.162-1.29-.484-1.864a.562.562 0 00-.62-.192.689.689 0 01.918.178l.033.035c.136.187.237.397.299.62.339.992.434 2.032.494 3.064.08 1.353.108 2.718-.322 4.02a6.304 6.304 0 00-.387 1.955 1.192 1.192 0 01-.582 1.055 5.302 5.302 0 01-3.204.944c-.69-.025-1.357-.203-1.702-.898.045-.006.101-.053.124-.04z'
                fill='#CC8F00'
            />
            <Path
                d='M55.416 25.62s.543-.418 1.227.217c.188.186.306.429.335.69.043.21.09.423.134.633-.194 1.08-.132 2.168-.056 3.255.04.592-.194 1.281.552 1.68-.434-.102-.812-.232-1.197-.35-.156-.047-.27-.093-.13-.265.447-.553.387-1.22.426-1.865.035-.574-.23-1.13-.159-1.69.087-.698.083-1.352-.265-1.915-.078-.129-.394-.533-.867-.39zM53.793 25.148a.94.94 0 01.998-.163c.04.015.078.032.114.054.208.153.38.349.504.574a20.511 20.511 0 000 2.652c.036.45.043.901.023 1.352-.056.643-.138 1.296.271 1.962-.43-.2-.86-.017-1.244-.268.3-.283.492-.659.547-1.064.217-1.314.013-2.618.021-3.925a1.536 1.536 0 00-.403-1.15c-.11-.1-.393-.271-.831-.024z'
                fill='#CC8F00'
            />
            <Path
                d='M43.998 22.217l-.217.457a.808.808 0 00.088.833l2.13 2.813a.072.072 0 00.12-.012.07.07 0 00.007-.046c-.159-.708-.657-2.521-1.85-4.076a.166.166 0 00-.147-.059.167.167 0 00-.13.09zM46.643 23.159s-.304-.211-.451.095c-.105.219.31 1.004.562 1.446a.093.093 0 00.174-.048c-.023-.51-.09-1.392-.285-1.493zM48.174 19.925l-.165.023a.423.423 0 00-.277.163.413.413 0 00-.08.31l.727 5.014c.003.013.01.024.02.033a.057.057 0 00.09-.033l.727-5.014a.414.414 0 00-.079-.31.424.424 0 00-.277-.163l-.163-.023a1.842 1.842 0 00-.523 0zM52.87 22.217l.218.457a.804.804 0 01-.088.833L50.87 26.32a.072.072 0 01-.119-.012.07.07 0 01-.007-.046c.159-.708.657-2.521 1.85-4.076a.166.166 0 01.147-.059.168.168 0 01.13.09zM50.228 23.159s.302-.211.45.095c.104.219-.31 1.004-.563 1.446a.092.092 0 01-.157.011.09.09 0 01-.015-.059c.021-.51.087-1.392.285-1.493z'
                fill={theme.centerChannelColor}
            />
            <Path
                d='M37.423 84.01s.554-6.606 4.046-9.936c3.491-3.329 6.832-5.533 13.882-5.963 7.05-.43 11.468 6.683 12.152 7.951.685 1.268 2.713 5.03 2.713 7.948 0 2.916.02 9.044-4.158 11.765-4.18 2.722-8.201 4.308-11.086 4.157-2.885-.15-10.177-.754-13.444-5.292-3.267-4.538-4.105-5.988-4.105-10.63z'
                fill='#FFBC1F'
            />
            <Path
                d='M54.39 71.542a5.873 5.873 0 014.439.503.205.205 0 00.303-.145.202.202 0 00-.023-.128c-.62-1.135-2.242-3.203-4.912-.573a.203.203 0 00.193.343z'
                fill='#FFD470'
            />
            <Path
                d='M47.813 96.925c-1.709-1.747-3.986-3.969-3.758-11.567.228-7.598 2.053-10.288 3.358-12.307.702-1.097 3.18-3.364 6.212-4.79-5.903.668-8.977 2.77-12.174 5.813-3.509 3.326-4.046 9.932-4.046 9.932 0 4.643.856 6.096 4.123 10.63 3.268 4.535 10.556 5.143 13.444 5.293-.003 0-5.45-1.247-7.159-3.004z'
                fill='#CC8F00'
            />
            <Path
                d='M55.435 95.16s9.124.172 10.724-8.328a1.15 1.15 0 00-.55-1.221 1.164 1.164 0 00-.45-.152 88.607 88.607 0 00-20.409.308 1.15 1.15 0 00-.962.885 1.137 1.137 0 00-.006.46c.442 2.372 2.456 7.493 11.653 8.048z'
                fill='#6F370B'
            />
            <Path
                d='M56.425 94.542s-5.572.416-7.9-1.907l.282-.21c.3-.177.622-.316.958-.412a7.565 7.565 0 011.79-.287c.35-.017.701-.024 1.07 0 .37.004.738.056 1.094.158.352.114.69.264 1.011.447.48.25.9.597 1.235 1.02.264.346.423.759.46 1.191z'
                fill='#C43133'
            />
            <Path
                d='M46.954 86.022s7.976-.493 16.9-.304c0 0-.456 1.778-8.696 1.778-1.86 0-7.86.72-8.204-1.474z'
                fill='#fff'
            />
            <Path
                d='M50.803 78.682c.088 2.033-.702 3.717-1.782 3.763-1.081.045-2.011-1.566-2.106-3.599-.095-2.033.702-3.713 1.783-3.759 1.08-.045 2.021 1.558 2.105 3.595zM62.952 78.693c.077 1.778-.621 3.252-1.562 3.294-.94.042-1.754-1.37-1.835-3.144-.08-1.775.621-3.253 1.562-3.294.94-.042 1.758 1.365 1.835 3.144z'
                fill='#6F370B'
            />
        </Svg>
    );
};

export default CallsSvg;
