import { timestampInSeconds } from '@sentry/core';
import { getClient, Profiler } from '@sentry/react';
import { createIntegration } from '../integrations/factory';
import { _captureAppStart, _setRootComponentCreationTimestampMs } from '../tracing/integrations/appStart';
const ReactNativeProfilerGlobalState = {
    appStartReported: false,
};
/**
 * Custom profiler for the React Native app root.
 */
export class ReactNativeProfiler extends Profiler {
    constructor(props) {
        _setRootComponentCreationTimestampMs(timestampInSeconds() * 1000);
        super(props);
        this.name = 'ReactNativeProfiler';
    }
    /**
     * Get the app root mount time.
     */
    componentDidMount() {
        super.componentDidMount();
        if (!ReactNativeProfilerGlobalState.appStartReported) {
            this._reportAppStart();
            ReactNativeProfilerGlobalState.appStartReported = true;
        }
    }
    /**
     * Notifies the Tracing integration that the app start has finished.
     */
    _reportAppStart() {
        const client = getClient();
        if (!client) {
            // We can't use logger here because this will be logged before the `Sentry.init`.
            // eslint-disable-next-line no-console
            __DEV__ && console.warn('App Start Span could not be finished. `Sentry.wrap` was called before `Sentry.init`.');
            return;
        }
        client.addIntegration && client.addIntegration(createIntegration(this.name));
        // eslint-disable-next-line @typescript-eslint/no-floating-promises
        _captureAppStart({ isManual: false });
    }
}
//# sourceMappingURL=reactnativeprofiler.js.map