/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.translateImplReturnType = exports.translateSpecReturnType = void 0;
const ObjectTypes_1 = require("./ObjectTypes");
function translateReturnType(type, aliases, baseAliasName, options) {
    switch (type.type) {
        case 'VoidTypeAnnotation':
        case 'PromiseTypeAnnotation':
            return 'void';
        case 'NullableTypeAnnotation':
            return `std::optional<${translateReturnType(type.typeAnnotation, aliases, baseAliasName, options)}>`;
        default:
            return (0, ObjectTypes_1.translateFieldOrReturnType)(type, aliases, baseAliasName, 'translateReturnType', options);
    }
}
function translateSpecReturnType(type, aliases, baseAliasName, options) {
    return translateReturnType(type, aliases, `${baseAliasName}_returnType`, options);
}
exports.translateSpecReturnType = translateSpecReturnType;
function translateImplReturnType(type, aliases, baseAliasName, options) {
    return translateReturnType(type, aliases, `${baseAliasName}_returnType`, options);
}
exports.translateImplReturnType = translateImplReturnType;
//# sourceMappingURL=ReturnTypes.js.map