"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.dependencyConfigWindows = void 0;
// Types in this file are inaccurate compared to usage in terms of falsiness.
// We should try to rewrite some of this to do automated schema validation to
// guarantee correct types
/* eslint-disable @typescript-eslint/no-unnecessary-condition */
const os_1 = require("os");
const path_1 = __importDefault(require("path"));
const configUtils = __importStar(require("./configUtils"));
/**
 * Gets the config of any RNW native modules under the target folder.
 * @param userConfig A manually specified override config.
 * @return The config if any RNW native modules exist.
 */
// Disabled due to existing high cyclomatic complexity
// eslint-disable-next-line complexity
function dependencyConfigWindows(folder, userConfig = {}) {
    if ((0, os_1.platform)() !== 'win32') {
        return null;
    }
    if (userConfig === null) {
        return null;
    }
    const usingManualProjectsOverride = 'projects' in userConfig && Array.isArray(userConfig.projects);
    const usingManualNugetPackagesOverride = 'nugetPackages' in userConfig && Array.isArray(userConfig.nugetPackages);
    const result = {
        folder,
        projects: usingManualProjectsOverride ? userConfig.projects : [],
        solutionFile: null,
        nugetPackages: usingManualNugetPackagesOverride
            ? userConfig.nugetPackages
            : [],
    };
    let sourceDir = null;
    if (usingManualProjectsOverride && result.projects.length > 0) {
        // Manually provided projects, so extract the sourceDir
        if (!('sourceDir' in userConfig)) {
            sourceDir =
                'Error: Source dir is required if projects are specified, but it is not specified in react-native.config.';
        }
        else if (userConfig.sourceDir === null) {
            sourceDir =
                'Error: Source dir is required if projects are specified, but it is null in react-native.config.';
        }
        else {
            sourceDir = path_1.default.join(folder, userConfig.sourceDir);
        }
    }
    else if (!usingManualProjectsOverride) {
        // No manually provided projects, try to find sourceDir
        if ('sourceDir' in userConfig && userConfig.sourceDir !== null) {
            sourceDir = path_1.default.join(folder, userConfig.sourceDir);
        }
        else {
            sourceDir = configUtils.findWindowsFolder(folder);
        }
    }
    if (sourceDir === null) {
        // Try to salvage the missing sourceDir
        if (result.projects.length === 0 && result.nugetPackages.length > 0) {
            // Only nuget packages, no sourceDir required
            return result;
        }
        else if (result.projects.length > 0) {
            // Projects overridden but no sourceDir, assume the sourceDir === folder
            sourceDir = folder;
        }
    }
    else if (sourceDir.startsWith('Error: ')) {
        // Source dir error, bail with error
        result.sourceDir = sourceDir;
        return result;
    }
    if (sourceDir === null) {
        // After everything above, if sourceDir is still null,
        // there's nothing more to look for here, bail
        return null;
    }
    result.sourceDir = path_1.default.relative(folder, sourceDir);
    const usingManualSolutionFile = 'solutionFile' in userConfig;
    let solutionFile = null;
    if (usingManualSolutionFile && userConfig.solutionFile !== null) {
        // Manually provided solutionFile, so extract it
        solutionFile = path_1.default.join(sourceDir, userConfig.solutionFile);
    }
    else if (!usingManualSolutionFile) {
        // No manually provided solutionFile, try to find it
        const foundSolutions = configUtils.findSolutionFiles(sourceDir);
        if (foundSolutions.length === 1) {
            solutionFile = path_1.default.join(sourceDir, foundSolutions[0]);
        }
    }
    result.solutionFile =
        solutionFile !== null ? path_1.default.relative(sourceDir, solutionFile) : null;
    if (usingManualProjectsOverride) {
        // react-native.config used, fill out (auto) items for each provided project, verify (req) items are present
        const alwaysRequired = [
            'projectFile',
            'directDependency',
        ];
        for (const project of result.projects) {
            // Verifying (req) items
            let errorFound = false;
            alwaysRequired.forEach(item => {
                if (!(item in project)) {
                    project[item] = `Error: ${item} is required for each project in react-native.config`;
                    errorFound = true;
                }
            });
            if (errorFound) {
                break;
            }
            const projectFile = path_1.default.join(sourceDir, project.projectFile);
            const projectContents = configUtils.readProjectFile(projectFile);
            project.projectFile = path_1.default.relative(sourceDir, projectFile);
            // Calculating (auto) items
            project.projectName = configUtils.getProjectName(projectFile, projectContents);
            project.projectLang = configUtils.getProjectLanguage(projectFile);
            project.projectGuid = configUtils.getProjectGuid(projectContents);
            if (project.directDependency) {
                // Calculating more (auto) items
                const projectNamespace = configUtils.getProjectNamespace(projectContents);
                if (projectNamespace !== null) {
                    const cppNamespace = projectNamespace.replace(/\./g, '::');
                    const csNamespace = projectNamespace.replace(/::/g, '.');
                    project.cppHeaders = project.cppHeaders || [`winrt/${csNamespace}.h`];
                    project.cppPackageProviders = project.cppPackageProviders || [
                        `${cppNamespace}::ReactPackageProvider`,
                    ];
                    project.csNamespaces = project.csNamespaces || [`${csNamespace}`];
                    project.csPackageProviders = project.csPackageProviders || [
                        `${csNamespace}.ReactPackageProvider`,
                    ];
                }
            }
        }
    }
    else {
        // No react-native.config, try to heuristically find any projects
        const foundProjects = configUtils.findDependencyProjectFiles(sourceDir);
        for (const foundProject of foundProjects) {
            const projectFile = path_1.default.join(sourceDir, foundProject);
            const projectContents = configUtils.readProjectFile(projectFile);
            const projectType = configUtils.getProjectType(projectFile, projectContents);
            if (projectType === 'dynamiclibrary' ||
                projectType === 'winmdobj' ||
                projectType === 'library') {
                const projectLang = configUtils.getProjectLanguage(projectFile);
                const projectName = configUtils.getProjectName(projectFile, projectContents);
                const projectGuid = configUtils.getProjectGuid(projectContents);
                const projectNamespace = configUtils.getProjectNamespace(projectContents);
                const directDependency = true;
                const cppHeaders = [];
                const cppPackageProviders = [];
                const csNamespaces = [];
                const csPackageProviders = [];
                if (projectNamespace !== null) {
                    const cppNamespace = projectNamespace.replace(/\./g, '::');
                    const csNamespace = projectNamespace.replace(/::/g, '.');
                    cppHeaders.push(`winrt/${csNamespace}.h`);
                    cppPackageProviders.push(`${cppNamespace}::ReactPackageProvider`);
                    csNamespaces.push(`${csNamespace}`);
                    csPackageProviders.push(`${csNamespace}.ReactPackageProvider`);
                }
                result.projects.push({
                    projectFile: path_1.default.relative(sourceDir, projectFile),
                    projectName,
                    projectLang,
                    projectGuid,
                    directDependency,
                    cppHeaders,
                    cppPackageProviders,
                    csNamespaces,
                    csPackageProviders,
                });
            }
            else {
                const projectPath = path_1.default.relative(sourceDir, projectFile);
                result.projects.push({
                    projectFile: `Error: ${projectPath} is type '${projectType}'`,
                    directDependency: false,
                    projectName: '',
                    projectLang: null,
                    projectGuid: null,
                    cppHeaders: [],
                    cppPackageProviders: [],
                    csNamespaces: [],
                    csPackageProviders: [],
                });
            }
        }
    }
    return result;
}
exports.dependencyConfigWindows = dependencyConfigWindows;
//# sourceMappingURL=dependencyConfig.js.map