# Installation
> `npm install --save @types/react-native-background-timer`

# Summary
This package contains type definitions for react-native-background-timer (https://github.com/ocetnik/react-native-background-timer#readme).

# Details
Files were exported from https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-native-background-timer.
## [index.d.ts](https://github.com/DefinitelyTyped/DefinitelyTyped/tree/master/types/react-native-background-timer/index.d.ts)
````ts
/*~ You can declare types that are available via importing the module */
export type IntervalId = number;
export type TimeoutId = number;

/*~ You can declare properties of the module using const, let, or var */
declare class BackgroundTimer {
    constructor();

    start(delay?: number): any;

    stop(): void;

    runBackgroundTimer(callback: () => void, delay: number): void;

    backgroundClockMethod(callback: () => void, delay: number): void;

    stopBackgroundTimer(): void;

    setTimeout(callback: () => void, timeout: number): TimeoutId;

    clearTimeout(timeoutId: TimeoutId): void;

    setInterval(callback: () => void, timeout: number): IntervalId;

    clearInterval(intervalId: IntervalId): void;
}

declare const _BackgroundTimer: BackgroundTimer;
export default _BackgroundTimer;

````

### Additional Details
 * Last updated: Tue, 07 Nov 2023 09:09:39 GMT
 * Dependencies: none

# Credits
These definitions were written by [Tjark Smalla](https://github.com/chillkroeteTTS).
