import { useEffect, useRef } from 'react';
import { NativeModules, Platform, findNodeHandle } from 'react-native';
export const MvcpScrollViewManager = NativeModules.MvcpScrollViewManager;
export const useMvcpTuner = (flRef, refReady, mvcp, extraData) => {
  const autoscrollToTopThreshold = useRef();
  const minIndexForVisible = useRef();
  useEffect(() => {
    let cleanupPromise;

    const enableMaintainVisibleContentPosition = () => {
      if (!mvcp || Platform.OS !== 'android' || !(flRef !== null && flRef !== void 0 && flRef.current)) {
        return;
      }

      if (autoscrollToTopThreshold.current === mvcp.autoscrollToTopThreshold && minIndexForVisible.current === mvcp.minIndexForVisible) {
        // Don't do anythinig if the values haven't changed
        return;
      }

      autoscrollToTopThreshold.current = mvcp.autoscrollToTopThreshold || -Number.MAX_SAFE_INTEGER;
      minIndexForVisible.current = mvcp.minIndexForVisible || 0;
      const viewTag = findNodeHandle(flRef.current);
      cleanupPromise = MvcpScrollViewManager.enableMaintainVisibleContentPosition(viewTag, autoscrollToTopThreshold.current, minIndexForVisible.current);
    };

    enableMaintainVisibleContentPosition();
    return () => {
      var _cleanupPromise;

      if (mvcp && autoscrollToTopThreshold.current === mvcp.autoscrollToTopThreshold && minIndexForVisible.current === mvcp.minIndexForVisible) {
        // Don't do anythinig if the values haven't changed
        return;
      }

      (_cleanupPromise = cleanupPromise) === null || _cleanupPromise === void 0 ? void 0 : _cleanupPromise.then(handle => {
        MvcpScrollViewManager.disableMaintainVisibleContentPosition(handle);
      });
    }; // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [refReady, extraData, mvcp]);
};
//# sourceMappingURL=useMvcpTuner.js.map