"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.ScrollViewManager = void 0;

var _react = _interopRequireWildcard(require("react"));

var _reactNative = require("react-native");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function () { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || typeof obj !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

const ScrollViewManager = _reactNative.NativeModules.MvcpScrollViewManager;
exports.ScrollViewManager = ScrollViewManager;

var _default = /*#__PURE__*/_react.default.forwardRef((props, forwardedRef) => {
  var _props$maintainVisibl, _props$maintainVisibl2;

  const flRef = (0, _react.useRef)(null);
  const isMvcpEnabledNative = (0, _react.useRef)(false);
  const handle = (0, _react.useRef)(null);
  const enableMvcpRetriesCount = (0, _react.useRef)(0);
  const isMvcpPropPresentRef = (0, _react.useRef)(!!props.maintainVisibleContentPosition);
  const autoscrollToTopThreshold = (0, _react.useRef)(((_props$maintainVisibl = props.maintainVisibleContentPosition) === null || _props$maintainVisibl === void 0 ? void 0 : _props$maintainVisibl.autoscrollToTopThreshold) || -Number.MAX_SAFE_INTEGER);
  const minIndexForVisible = (0, _react.useRef)(((_props$maintainVisibl2 = props.maintainVisibleContentPosition) === null || _props$maintainVisibl2 === void 0 ? void 0 : _props$maintainVisibl2.minIndexForVisible) || 1);
  const retryTimeoutId = (0, _react.useRef)();
  const debounceTimeoutId = (0, _react.useRef)();
  const disableMvcpRef = (0, _react.useRef)(async () => {
    isMvcpEnabledNative.current = false;

    if (!(handle !== null && handle !== void 0 && handle.current)) {
      return;
    }

    await ScrollViewManager.disableMaintainVisibleContentPosition(handle.current);
  });
  const enableMvcpWithRetriesRef = (0, _react.useRef)(() => {
    // debounce to wait till consecutive mvcp enabling
    // this ensures that always previous handles are disabled first
    if (debounceTimeoutId.current) {
      clearTimeout(debounceTimeoutId.current);
    }

    debounceTimeoutId.current = setTimeout(async () => {
      // disable any previous enabled handles
      await disableMvcpRef.current();

      if (!flRef.current || !isMvcpPropPresentRef.current || isMvcpEnabledNative.current || _reactNative.Platform.OS !== 'android') {
        return;
      }

      const scrollableNode = flRef.current.getScrollableNode();

      try {
        const _handle = await ScrollViewManager.enableMaintainVisibleContentPosition(scrollableNode, autoscrollToTopThreshold.current, minIndexForVisible.current);

        handle.current = _handle;
      } catch (error) {
        /**
         * enableMaintainVisibleContentPosition from native module may throw IllegalViewOperationException,
         * in case view is not ready yet. In that case, lets do a retry!! (max of 10 tries)
         */
        if (enableMvcpRetriesCount.current < 10) {
          retryTimeoutId.current = setTimeout(enableMvcpWithRetriesRef.current, 100);
          enableMvcpRetriesCount.current += 1;
        }
      }
    }, 300);
  });
  (0, _react.useEffect)(() => {
    var _props$maintainVisibl3, _props$maintainVisibl4;

    // when the mvcp prop changes
    // enable natively again, if the prop has changed
    const propAutoscrollToTopThreshold = ((_props$maintainVisibl3 = props.maintainVisibleContentPosition) === null || _props$maintainVisibl3 === void 0 ? void 0 : _props$maintainVisibl3.autoscrollToTopThreshold) || -Number.MAX_SAFE_INTEGER;
    const propMinIndexForVisible = ((_props$maintainVisibl4 = props.maintainVisibleContentPosition) === null || _props$maintainVisibl4 === void 0 ? void 0 : _props$maintainVisibl4.minIndexForVisible) || 1;
    const hasMvcpChanged = autoscrollToTopThreshold.current !== propAutoscrollToTopThreshold || minIndexForVisible.current !== propMinIndexForVisible || isMvcpPropPresentRef.current !== !!props.maintainVisibleContentPosition;

    if (hasMvcpChanged) {
      enableMvcpRetriesCount.current = 0;
      autoscrollToTopThreshold.current = propAutoscrollToTopThreshold;
      minIndexForVisible.current = propMinIndexForVisible;
      isMvcpPropPresentRef.current = !!props.maintainVisibleContentPosition;
      enableMvcpWithRetriesRef.current();
    }
  }, [props.maintainVisibleContentPosition]);
  const refCallback = (0, _react.useRef)(ref => {
    flRef.current = ref;
    enableMvcpWithRetriesRef.current();

    if (typeof forwardedRef === 'function') {
      forwardedRef(ref);
    } else if (forwardedRef) {
      forwardedRef.current = ref;
    }
  }).current;
  (0, _react.useEffect)(() => {
    const disableMvcp = disableMvcpRef.current;
    return () => {
      // clean up the retry mechanism
      if (debounceTimeoutId.current) {
        clearTimeout(debounceTimeoutId.current);
      } // clean up any debounce


      if (debounceTimeoutId.current) {
        clearTimeout(debounceTimeoutId.current);
      }

      disableMvcp();
    };
  }, []);
  return /*#__PURE__*/_react.default.createElement(_reactNative.FlatList, _extends({}, props, {
    ref: refCallback
  }));
});

exports.default = _default;
//# sourceMappingURL=FlatList.android.js.map