import type { Integration } from '@sentry/core';
export declare const MOBILE_REPLAY_INTEGRATION_NAME = "MobileReplay";
export interface MobileReplayOptions {
    /**
     * Mask all text in recordings
     *
     * @default true
     */
    maskAllText?: boolean;
    /**
     * Mask all images in recordings
     *
     * @default true
     */
    maskAllImages?: boolean;
    /**
     * Mask all vector graphics in recordings
     * Supports `react-native-svg`
     *
     * @default true
     */
    maskAllVectors?: boolean;
    /**
     * Enables the up to 5x faster experimental view renderer used by the Session Replay integration on iOS.
     *
     * Enabling this flag will reduce the amount of time it takes to render each frame of the session replay on the main thread, therefore reducing
     * interruptions and visual lag.
     *
     * - Experiment: This is an experimental feature and is therefore disabled by default.
     *
     * @default false
     */
    enableExperimentalViewRenderer?: boolean;
    /**
     * Enables up to 5x faster but incomplete view rendering used by the Session Replay integration on iOS.
     *
     * Enabling this flag will reduce the amount of time it takes to render each frame of the session replay on the main thread, therefore reducing
     * interruptions and visual lag.
     *
     * - Note: This flag can only be used together with `enableExperimentalViewRenderer` with up to 20% faster render times.
     * - Experiment: This is an experimental feature and is therefore disabled by default.
     *
     * @default false
     */
    enableFastViewRendering?: boolean;
}
type MobileReplayIntegration = Integration & {
    options: Required<MobileReplayOptions>;
};
/**
 * The Mobile Replay Integration, let's you adjust the default mobile replay options.
 * To be passed to `Sentry.init` with `replaysOnErrorSampleRate` or `replaysSessionSampleRate`.
 *
 * ```javascript
 * Sentry.init({
 *  replaysOnErrorSampleRate: 1.0,
 *  replaysSessionSampleRate: 1.0,
 *  integrations: [mobileReplayIntegration({
 *    // Adjust the default options
 *  })],
 * });
 * ```
 *
 * @experimental
 */
export declare const mobileReplayIntegration: (initOptions?: MobileReplayOptions) => MobileReplayIntegration;
export {};
//# sourceMappingURL=mobilereplay.d.ts.map
