/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
'use strict';
Object.defineProperty(exports, "__esModule", { value: true });
exports.generateValidateMethods = void 0;
const ParamTypes_1 = require("./ParamTypes");
const ReturnTypes_1 = require("./ReturnTypes");
function isMethodSync(funcType) {
    return (funcType.returnTypeAnnotation.type !== 'VoidTypeAnnotation' &&
        funcType.returnTypeAnnotation.type !== 'PromiseTypeAnnotation');
}
function getPossibleMethodSignatures(prop, funcType, aliases, baseAliasName, options) {
    const args = (0, ParamTypes_1.translateArgs)(funcType.params, aliases, baseAliasName, options);
    if (funcType.returnTypeAnnotation.type === 'PromiseTypeAnnotation') {
        if (funcType.returnTypeAnnotation.elementType) {
            args.push(`::React::ReactPromise<${(0, ReturnTypes_1.translateImplReturnType)(funcType.returnTypeAnnotation.elementType, aliases, baseAliasName, options)}> &&result`);
        }
        else {
            args.push('::React::ReactPromise<::React::JSValue> &&result');
        }
    }
    // TODO: be much more exhaustive on the possible method signatures that can be used..
    const sig = `REACT_${isMethodSync(funcType) ? 'SYNC_' : ''}METHOD(${prop.name}) ${(0, ReturnTypes_1.translateImplReturnType)(funcType.returnTypeAnnotation, aliases, baseAliasName, options)} ${prop.name}(${args.join(', ')}) noexcept { /* implementation */ }`;
    const staticsig = `REACT_${isMethodSync(funcType) ? 'SYNC_' : ''}METHOD(${prop.name}) static ${(0, ReturnTypes_1.translateImplReturnType)(funcType.returnTypeAnnotation, aliases, baseAliasName, options)} ${prop.name}(${args.join(', ')}) noexcept { /* implementation */ }`;
    return [sig, staticsig];
}
function translatePossibleMethodSignatures(prop, funcType, aliases, baseAliasName, options) {
    return getPossibleMethodSignatures(prop, funcType, aliases, baseAliasName, options)
        .map(sig => `"    ${sig}\\n"`)
        .join('\n          ');
}
function renderProperties(properties, aliases, tuple, options) {
    // TODO: generate code for constants
    return properties
        .filter(prop => prop.name !== 'getConstants')
        .map((prop, index) => {
        // TODO: prop.optional === true
        // TODO: prop.typeAnnotation.type === 'NullableTypeAnnotation'
        const propAliasName = prop.name;
        const funcType = prop.typeAnnotation.type === 'NullableTypeAnnotation'
            ? prop.typeAnnotation.typeAnnotation
            : prop.typeAnnotation;
        const traversedArgs = (0, ParamTypes_1.translateSpecArgs)(funcType.params, aliases, propAliasName, options);
        const translatedReturnParam = (0, ReturnTypes_1.translateSpecReturnType)(funcType.returnTypeAnnotation, aliases, propAliasName, options);
        if (funcType.returnTypeAnnotation.type === 'PromiseTypeAnnotation') {
            if (funcType.returnTypeAnnotation.elementType) {
                traversedArgs.push(`Promise<${(0, ReturnTypes_1.translateSpecReturnType)(funcType.returnTypeAnnotation.elementType, aliases, propAliasName, options)}>`);
            }
            else {
                traversedArgs.push('Promise<::React::JSValue>');
            }
        }
        if (tuple) {
            return `      ${isMethodSync(funcType) ? 'Sync' : ''}Method<${translatedReturnParam}(${traversedArgs.join(', ')}) noexcept>{${index}, L"${prop.name}"},`;
        }
        else {
            return `    REACT_SHOW_METHOD_SPEC_ERRORS(
          ${index},
          "${prop.name}",
          ${translatePossibleMethodSignatures(prop, funcType, aliases, propAliasName, options)});`;
        }
    })
        .join('\n');
}
function generateValidateMethods(nativeModule, aliases, options) {
    const properties = nativeModule.spec.properties;
    const traversedProperties = renderProperties(properties, aliases, false, options);
    const traversedPropertyTuples = renderProperties(properties, aliases, true, options);
    return [traversedPropertyTuples, traversedProperties];
}
exports.generateValidateMethods = generateValidateMethods;
//# sourceMappingURL=ValidateMethods.js.map