/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import type { NativeModuleBaseTypeAnnotation, NativeModuleStringTypeAnnotation, NativeModuleFunctionTypeAnnotation, Nullable } from '@react-native/codegen/lib/CodegenSchema';
import { AliasMap } from './AliasManaging';
export type CppStringTypes = 'std::string' | 'std::wstring';
export interface CppCodegenOptions {
    cppStringType: CppStringTypes;
}
export declare function translateFieldOrReturnType(type: Nullable<NativeModuleBaseTypeAnnotation | NativeModuleStringTypeAnnotation | NativeModuleFunctionTypeAnnotation>, aliases: AliasMap, baseAliasName: string, callerName: 'translateField' | 'translateReturnType', options: CppCodegenOptions): string;
export declare function translateField(type: Nullable<NativeModuleBaseTypeAnnotation>, aliases: AliasMap, baseAliasName: string, options: CppCodegenOptions): string;
