/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import ora from 'ora';
import { CodedErrorType } from '@react-native-windows/telemetry';
export declare function newSpinner(text: string): ora.Ora;
export declare const powershell: string;
export declare function runPowerShellScriptFunction(taskDescription: string, script: string | null, funcName: string, verbose: boolean, errorCategory: CodedErrorType): Promise<void>;
export declare function commandWithProgress(spinner: ora.Ora, taskDoingName: string, command: string, args: string[], verbose: boolean, errorCategory: CodedErrorType): Promise<void>;
export declare function newError(text: string): void;
export declare function newWarn(text: string): void;
export declare function newSuccess(text: string): void;
export declare function newInfo(text: string): void;
/**
 * Sets the process exit code and offers some information at the end of a CLI command.
 * @param loggingIsEnabled Is verbose logging enabled.
 * @param error The error caught during the process, if any.
 */
export declare function setExitProcessWithError(loggingIsEnabled?: boolean, error?: Error): void;
