"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __exportStar = (this && this.__exportStar) || function(m, exports) {
    for (var p in m) if (p !== "default" && !Object.prototype.hasOwnProperty.call(exports, p)) __createBinding(exports, m, p);
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.projectConfig = exports.dependencyConfig = exports.commands = exports.generateWindows = void 0;
const fs_1 = __importDefault(require("@react-native-windows/fs"));
const path_1 = __importDefault(require("path"));
const generator_windows_1 = require("./generator-windows");
const pathHelpers = __importStar(require("./utils/pathHelpers"));
const autolinkWindows_1 = require("./commands/autolinkWindows/autolinkWindows");
const codegenWindows_1 = require("./commands/codegenWindows/codegenWindows");
const initWindows_1 = require("./commands/initWindows/initWindows");
const runWindows_1 = require("./commands/runWindows/runWindows");
const dependencyConfig_1 = require("./commands/config/dependencyConfig");
const projectConfig_1 = require("./commands/config/projectConfig");
/**
 * Simple utility for running the Windows generator.
 *
 * @param  projectDir root project directory (i.e. contains index.js)
 * @param  name       name of the root JS module for this app
 * @param  ns         namespace for the project
 * @param  options    command line options container
 */
async function generateWindows(projectDir, name, ns, options) {
    if (!fs_1.default.existsSync(projectDir)) {
        fs_1.default.mkdirSync(projectDir);
    }
    await (0, generator_windows_1.installScriptsAndDependencies)(options);
    const rnwPackage = pathHelpers.resolveRnwRoot(projectDir);
    const templateRoot = path_1.default.join(rnwPackage, 'template');
    await (0, generator_windows_1.copyProjectTemplateAndReplace)(templateRoot, projectDir, name, ns, options);
}
exports.generateWindows = generateWindows;
// Assert the interface here doesn't change for the reasons above
const assertStableInterface = true;
assertStableInterface;
exports.commands = [
    autolinkWindows_1.autolinkCommand,
    codegenWindows_1.codegenCommand,
    initWindows_1.initCommand,
    runWindows_1.runWindowsCommand,
];
exports.dependencyConfig = dependencyConfig_1.dependencyConfigWindows;
exports.projectConfig = projectConfig_1.projectConfigWindows;
__exportStar(require("./commands/healthCheck/healthChecks"), exports);
//# sourceMappingURL=index.js.map