/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
/**
 * Text to replace, + config options
 */
export type Replacements = {
    useMustache?: boolean;
    regExpPatternsToRemove?: RegExp[];
    [key: string]: any;
};
/**
 * Get a source file and replace parts of its contents.
 * @param srcPath Path to the source file.
 * @param replacements e.g. {'TextToBeReplaced': 'Replacement'}
 * @return The contents of the file with the replacements applied.
 */
export declare function resolveContents(srcPath: string, replacements: Replacements): string;
type ContentChangedCallbackOption = 'identical' | 'changed' | 'new' | null;
type ContentChangedCallback = (path: string, option: ContentChangedCallbackOption) => Promise<'keep' | 'overwrite'>;
/**
 * Copy a file to given destination, replacing parts of its contents.
 * @param srcPath Path to a file to be copied.
 * @param destPath Destination path.
 * @param replacements: e.g. {'TextToBeReplaced': 'Replacement'}
 * @param contentChangedCallback
 *        Used when upgrading projects. Based on if file contents would change
 *        when being replaced, allows the caller to specify whether the file
 *        should be replaced or not.
 *        If null, files will be overwritten.
 *        Function(path, 'identical' | 'changed' | 'new') => 'keep' | 'overwrite'
 */
export declare function copyAndReplace(srcPath: string, destPath: string, replacements: Replacements, contentChangedCallback: ContentChangedCallback | null): Promise<void>;
export declare function createDir(destPath: string): void;
export declare function copyAndReplaceWithChangedCallback(srcPath: string, destRoot: string, relativeDestPath: string, replacements?: Record<string, string>, alwaysOverwrite?: boolean): Promise<void>;
export declare function copyAndReplaceAll(srcPath: string, destPath: string, relativeDestDir: string, replacements: Replacements, alwaysOverwrite: boolean): Promise<void>;
export {};
