/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
import { Ora } from 'ora';
import { Command, Config } from '@react-native-community/cli-types';
import { InitOptions } from './initWindowsOptions';
export interface TemplateFileMapping {
    from: string;
    to: string;
    replacements?: Record<string, any>;
}
export interface InitWindowsTemplateConfig {
    name: string;
    description: string;
    isDefault?: boolean;
    preInstall?: (config: Config, options: InitOptions) => Promise<void>;
    getFileMappings?: (config: Config, options: InitOptions) => Promise<TemplateFileMapping[]>;
    postInstall?: (config: Config, options: InitOptions) => Promise<void>;
}
export declare class InitWindows {
    readonly config: Config;
    readonly options: InitOptions;
    protected readonly rnwPath: string;
    protected readonly templates: Map<string, InitWindowsTemplateConfig>;
    constructor(config: Config, options: InitOptions);
    protected verboseMessage(message: any): void;
    protected loadTemplates(): Promise<void>;
    protected getDefaultTemplateName(): string;
    protected pascalCase(str: string): string;
    protected isValidProjectName(name: string): boolean;
    protected getReactNativeProjectName(projectDir: string): string;
    run(spinner: Ora): Promise<void>;
}
/**
 * Initializes a new RNW project from a given template.
 * @param args Unprocessed args passed from react-native CLI.
 * @param config Config passed from react-native CLI.
 * @param options Options passed from react-native CLI.
 */
export declare function initWindowsInternal(args: string[], config: Config, options: InitOptions): Promise<void>;
/**
 * Initializes a new RNW project from a given template.
 */
export declare const initCommand: Command;
