"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getSupportedNumberingSystems = getSupportedNumberingSystems;
var ecma402_abstract_1 = require("@formatjs/ecma402-abstract");
var numbering_systems_generated_1 = require("./numbering-systems.generated");
function isSupportedNumberingSystem(system, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        var numberFormat = (0, ecma402_abstract_1.createMemoizedNumberFormat)("".concat(locale, "-u-nu-").concat(system));
        var options = numberFormat.resolvedOptions().numberingSystem;
        if ((options === system && system === 'latn') ||
            numberFormat.format(123) !== '123') {
            return true;
        }
    }
    catch (_err) { }
    return false;
}
function getSupportedNumberingSystems(locale) {
    return numbering_systems_generated_1.numberingSystemNames.filter(function (numberingSystemName) {
        return isSupportedNumberingSystem(numberingSystemName, locale);
    });
}
