/**
 * An enum representing the different types of devices supported by Expo.
 */
export enum DeviceType {
  /**
   * An unrecognized device type.
   */
  UNKNOWN = 0,
  /**
   * Mobile phone handsets, typically with a touch screen and held in one hand.
   */
  PHONE,
  /**
   * Tablet computers, typically with a touch screen that is larger than a usual phone.
   */
  TABLET,
  /**
   * Desktop or laptop computers, typically with a keyboard and mouse.
   */
  DESKTOP,
  /**
   * Device with TV-based interfaces.
   */
  TV,
}
