import Constants = require("../Declarations/Constants");
import Config = require("../Library/Config");
import Context = require("../Library/Context");
declare class Statsbeat {
    static NON_EU_CONNECTION_STRING: string;
    static EU_CONNECTION_STRING: string;
    static STATS_COLLECTION_SHORT_INTERVAL: number;
    static STATS_COLLECTION_LONG_INTERVAL: number;
    private static TAG;
    private _networkStatsbeatCollection;
    private _sender;
    private _context;
    private _handle;
    private _longHandle;
    private _isEnabled;
    private _isInitialized;
    private _config;
    private _statsbeatConfig;
    private _isVM;
    private _statbeatMetrics;
    private _resourceProvider;
    private _resourceIdentifier;
    private _sdkVersion;
    private _runtimeVersion;
    private _os;
    private _language;
    private _cikey;
    private _attach;
    private _feature;
    private _instrumentation;
    constructor(config: Config, context?: Context);
    enable(isEnabled: boolean): void;
    isInitialized(): boolean;
    isEnabled(): boolean;
    setCodelessAttach(): void;
    addFeature(feature: Constants.StatsbeatFeature): void;
    removeFeature(feature: Constants.StatsbeatFeature): void;
    addInstrumentation(instrumentation: Constants.StatsbeatInstrumentation): void;
    removeInstrumentation(instrumentation: Constants.StatsbeatInstrumentation): void;
    countRequest(endpoint: number, host: string, duration: number, success: boolean, statusCode?: number): void;
    countException(endpoint: number, host: string, exceptionType: Error): void;
    countThrottle(endpoint: number, host: string, statusCode: number): void;
    countRetry(endpoint: number, host: string, statusCode: number): void;
    trackShortIntervalStatsbeats(): Promise<void>;
    trackLongIntervalStatsbeats(): Promise<void>;
    private _getNetworkStatsbeatCounter;
    private _trackRequestDuration;
    private _getShortHost;
    private _trackRequestsCount;
    private _sendStatsbeats;
    private _getCustomProperties;
    private _getResourceProvider;
    private _shutdownStatsbeat;
    private _getConnectionString;
}
export = Statsbeat;
