import { Rule, Linter } from 'eslint';
import { UnprefixedRuleOptions } from './rule-options.js';
export { RuleOptions } from './rule-options.js';

type Rules = {
  [K in keyof UnprefixedRuleOptions]: Rule.RuleModule
}

declare const plugin: {
  rules: Rules
  configs: {
    /**
     * Disable all legacy rules from `eslint`
     *
     * This config works for both flat and legacy config format
     */
    'disable-legacy': Linter.Config
    /**
     * Enable all rules, in Flat Config Format
     */
    'all': Linter.Config
    /**
     * Enable all rules, in Flat Config Format
     *
     * @deprecated use `all` instead
     */
    'all-flat': Linter.Config
  }
}

export { type Rules, UnprefixedRuleOptions, plugin as default };
