import { d as createAllConfigs } from './utils.js';
import blockSpacing from './rules/block-spacing.js';
import braceStyle from './rules/brace-style.js';
import commaDangle from './rules/comma-dangle.js';
import commaSpacing from './rules/comma-spacing.js';
import functionCallSpacing from './rules/function-call-spacing.js';
import indent from './rules/indent.js';
import keySpacing from './rules/key-spacing.js';
import keywordSpacing from './rules/keyword-spacing.js';
import linesAroundComment from './rules/lines-around-comment.js';
import linesBetweenClassMembers from './rules/lines-between-class-members.js';
import memberDelimiterStyle from './rules/member-delimiter-style.js';
import noExtraParens from './rules/no-extra-parens.js';
import noExtraSemi from './rules/no-extra-semi.js';
import objectCurlyNewline from './rules/object-curly-newline.js';
import objectCurlySpacing from './rules/object-curly-spacing.js';
import objectPropertyNewline from './rules/object-property-newline.js';
import paddingLineBetweenStatements from './rules/padding-line-between-statements.js';
import quoteProps from './rules/quote-props.js';
import quotes from './rules/quotes.js';
import semiSpacing from './rules/semi-spacing.js';
import semi from './rules/semi.js';
import spaceBeforeBlocks from './rules/space-before-blocks.js';
import spaceBeforeFunctionParen from './rules/space-before-function-paren.js';
import spaceInfixOps from './rules/space-infix-ops.js';
import typeAnnotationSpacing from './rules/type-annotation-spacing.js';

var rules = {
  "block-spacing": blockSpacing,
  "brace-style": braceStyle,
  "comma-dangle": commaDangle,
  "comma-spacing": commaSpacing,
  "func-call-spacing": functionCallSpacing,
  "function-call-spacing": functionCallSpacing,
  "indent": indent,
  "key-spacing": keySpacing,
  "keyword-spacing": keywordSpacing,
  "lines-around-comment": linesAroundComment,
  "lines-between-class-members": linesBetweenClassMembers,
  "member-delimiter-style": memberDelimiterStyle,
  "no-extra-parens": noExtraParens,
  "no-extra-semi": noExtraSemi,
  "object-curly-newline": objectCurlyNewline,
  "object-curly-spacing": objectCurlySpacing,
  "object-property-newline": objectPropertyNewline,
  "padding-line-between-statements": paddingLineBetweenStatements,
  "quote-props": quoteProps,
  "quotes": quotes,
  "semi": semi,
  "semi-spacing": semiSpacing,
  "space-before-blocks": spaceBeforeBlocks,
  "space-before-function-paren": spaceBeforeFunctionParen,
  "space-infix-ops": spaceInfixOps,
  "type-annotation-spacing": typeAnnotationSpacing
};

var plugin = {
  rules
};

const config = {
  rules: {
    "@typescript-eslint/block-spacing": 0,
    "@typescript-eslint/brace-style": 0,
    "@typescript-eslint/comma-dangle": 0,
    "@typescript-eslint/comma-spacing": 0,
    "@typescript-eslint/func-call-spacing": 0,
    "@typescript-eslint/indent": 0,
    "@typescript-eslint/key-spacing": 0,
    "@typescript-eslint/keyword-spacing": 0,
    "@typescript-eslint/lines-around-comment": 0,
    "@typescript-eslint/lines-between-class-members": 0,
    "@typescript-eslint/member-delimiter-style": 0,
    "@typescript-eslint/no-extra-parens": 0,
    "@typescript-eslint/no-extra-semi": 0,
    "@typescript-eslint/object-curly-newline": 0,
    "@typescript-eslint/object-curly-spacing": 0,
    "@typescript-eslint/object-property-newline": 0,
    "@typescript-eslint/padding-line-between-statements": 0,
    "@typescript-eslint/quote-props": 0,
    "@typescript-eslint/quotes": 0,
    "@typescript-eslint/semi": 0,
    "@typescript-eslint/semi-spacing": 0,
    "@typescript-eslint/space-before-blocks": 0,
    "@typescript-eslint/space-before-function-paren": 0,
    "@typescript-eslint/space-infix-ops": 0,
    "@typescript-eslint/type-annotation-spacing": 0
  }
};

const all = /* @__PURE__ */ createAllConfigs(plugin, "@stylistic/ts");
const configs = {
  "disable-legacy": config,
  all,
  /**
   * @deprecated use `all` instead.
   */
  "all-flat": all
};

export { configs as c, plugin as p };
