import type { Integration } from '@sentry/core';
export declare const INTEGRATION_NAME = "ReactNavigation";
interface ReactNavigationIntegrationOptions {
    /**
     * How long the instrumentation will wait for the route to mount after a change has been initiated,
     * before the transaction is discarded.
     *
     * @default 1_000 (ms)
     */
    routeChangeTimeoutMs: number;
    /**
     * Time to initial display measures the time it takes from
     * navigation dispatch to the render of the first frame of the new screen.
     *
     * @default false
     */
    enableTimeToInitialDisplay: boolean;
    /**
     * Does not sample transactions that are from routes that have been seen any more and don't have any spans.
     * This removes a lot of the clutter as most back navigation transactions are now ignored.
     *
     * @default true
     */
    ignoreEmptyBackNavigationTransactions: boolean;
}
/**
 * Instrumentation for React-Navigation V5 and above. See docs or sample app for usage.
 *
 * How this works:
 * - `_onDispatch` is called every time a dispatch happens and sets an IdleTransaction on the scope without any route context.
 * - `_onStateChange` is then called AFTER the state change happens due to a dispatch and sets the route context onto the active transaction.
 * - If `_onStateChange` isn't called within `STATE_CHANGE_TIMEOUT_DURATION` of the dispatch, then the transaction is not sampled and finished.
 */
export declare const reactNavigationIntegration: ({ routeChangeTimeoutMs, enableTimeToInitialDisplay, ignoreEmptyBackNavigationTransactions, }?: Partial<ReactNavigationIntegrationOptions>) => Integration & {
    /**
     * Pass the ref to the navigation container to register it to the instrumentation
     * @param navigationContainerRef Ref to a `NavigationContainer`
     */
    registerNavigationContainer: (navigationContainerRef: unknown) => void;
};
export interface NavigationRoute {
    name: string;
    key: string;
    params?: Record<string, any>;
}
export {};
//# sourceMappingURL=reactnavigation.d.ts.map