/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
/**
 * Gets the version of node being used.
 * @returns The version of node being used.
 */
export declare function getNodeVersion(): Promise<string | null>;
/**
 * Gets the version of npm installed, if available.
 * @returns The version of npm installed, if available.
 */
export declare function getNpmVersion(): Promise<string | null>;
/**
 * Gets the version of yarn installed, if available.
 * @returns The version of yarn installed, if available.
 */
export declare function getYarnVersion(): Promise<string | null>;
/**
 * Gets the latest version of Visual Studio installed, if available.
 * @returns The latest version of Visual Studio installed, if available.
 */
export declare function getVisualStudioVersion(): Promise<string | null>;
/**
 * Gets the version installed of the specified npm package.
 * @param pkgName The npm package name.
 * @returns The version installed, if available.
 */
export declare function getVersionOfNpmPackage(pkgName: string): Promise<string | null>;
/**
 * Gets the versions of the specified NuGet packages referenced in a project file.
 * @param projectFile Path to the native project file.
 * @param nugetPackages The NuGet package names to look for.
 * @returns The mapping of NuGet package names and their versions.
 */
export declare function getVersionsOfNuGetPackages(projectFile: string, nugetPackages: string[]): Promise<Record<string, string>>;
