"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path_1 = __importDefault(require("path"));
const child_process_1 = require("child_process");
const projectUtils = __importStar(require("../utils/projectUtils"));
test('getProjectId() does not match project name', () => {
    const projectName = 'test-project';
    expect(projectUtils.getProjectId(projectName)).not.toContain(projectName);
});
test('getProjectId() does not change for same project name', () => {
    const projectName = 'test-project';
    expect(projectUtils.getProjectId(projectName)).toBe(projectUtils.getProjectId(projectName));
});
test('getProjectId() returns different ids for different project names', () => {
    const projectName1 = 'test-project1';
    const projectName2 = 'test-project2';
    expect(projectUtils.getProjectId(projectName1)).not.toBe(projectUtils.getProjectId(projectName2));
});
test('usesReactNativeConfig() is false with no react-native.config.js present', async () => {
    const projectRoot = path_1.default.resolve(__dirname, 'projects/BlankUsesTypeScript');
    const value = await projectUtils.usesReactNativeConfig(projectRoot);
    expect(value).toBe(false);
});
test('usesReactNativeConfig() is true with react-native.config.js present', async () => {
    const projectRoot = path_1.default.resolve(__dirname, 'projects/BlankUsesReactNativeConfig');
    const value = await projectUtils.usesReactNativeConfig(projectRoot);
    expect(value).toBe(true);
});
test('usesTypeScript() is false with no tsconfig.json present', async () => {
    const projectRoot = path_1.default.resolve(__dirname, 'projects/BlankUsesReactNativeConfig');
    const value = await projectUtils.usesTypeScript(projectRoot);
    expect(value).toBe(false);
});
test('usesTypeScript() is true with tsconfig.json present', async () => {
    const projectRoot = path_1.default.resolve(__dirname, 'projects/BlankUsesTypeScript');
    const value = await projectUtils.usesTypeScript(projectRoot);
    expect(value).toBe(true);
});
test('configToProjectInfo() works with playground project info', async () => {
    const playgroundRoot = path_1.default.resolve(__dirname, '../../../../playground');
    const config = JSON.parse((0, child_process_1.execSync)('npx react-native config', {
        cwd: playgroundRoot,
        stdio: ['ignore', 'pipe', 'ignore'],
    }).toString());
    const info = await projectUtils.configToProjectInfo(config);
    expect(info).not.toBeNull();
    const projectInfo = info;
    expect(projectInfo.id).toBe(projectUtils.getProjectId('playground'));
    expect(projectInfo.platforms).toStrictEqual(['windows']);
    expect(projectInfo.rnwLang).toBe('cpp');
    expect(projectInfo.usesTS).toBe(true);
    expect(projectInfo.usesRNConfig).toBe(true);
    expect(projectInfo.jsEngine).toBe('Hermes');
    expect(projectInfo.rnwSource).toBe('Source');
}, 200000 /* Increase timeout of this test */);
//# sourceMappingURL=projectUtils.test.js.map