"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 *
 * @format
 * @ts-check
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const find_up_1 = __importDefault(require("find-up"));
const fs_1 = __importDefault(require("@react-native-windows/fs"));
const path_1 = __importDefault(require("path"));
/**
 * Find the root directory of a repo upward from cwd
 */
async function findRepoRoot() {
    const root = await (0, find_up_1.default)(async (dir) => {
        return (await find_up_1.default.exists(path_1.default.join(dir, '.git'))) ? dir : undefined;
    }, { type: 'directory' });
    if (!root) {
        throw new Error('Unable to find the root of react-native-windows. Are you running within the repo?');
    }
    return root;
}
/**
 * Synchronously finds the root directory of a repo upward from cwd
 */
function findRepoRootSync() {
    const root = find_up_1.default.sync((dir) => {
        return fs_1.default.existsSync(path_1.default.join(dir, '.git')) ? dir : undefined;
    }, { type: 'directory' });
    if (!root) {
        throw new Error('Unable to find the root of react-native-windows. Are you running within the repo?');
    }
    return root;
}
const exportObj = Object.assign(findRepoRoot, { sync: findRepoRootSync });
exports.default = exportObj;
//# sourceMappingURL=findRepoRoot.js.map