"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getEnvironmentInfo = void 0;
// @ts-ignore no typings
const envinfo_1 = __importDefault(require("envinfo"));
async function getEnvironmentInfo() {
    return await envinfo_1.default.run({
        System: ['OS', 'CPU', 'Memory', 'Shell'],
        Binaries: ['Node', 'Yarn', 'npm', 'Watchman'],
        npmPackages: [
            'react',
            'react-native',
            'react-native-windows',
            '@react-native-community/cli',
            'react-native-cli',
        ],
        npmGlobalPackages: ['*react-native*'],
    });
}
exports.getEnvironmentInfo = getEnvironmentInfo;
//# sourceMappingURL=info.js.map