"use strict";
/**
 * Copyright (c) Microsoft Corporation. All rights reserved.
 * Licensed under the MIT License.
 * @format
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const child_process_1 = require("child_process");
const path_1 = __importDefault(require("path"));
const commandWithProgress_1 = require("../utils/commandWithProgress");
const healthCheckList_1 = require("../commands/healthCheck/healthCheckList");
test('Verify list of health checks aligns with rnw-dependencies', async () => {
    const rnwDepScriptPath = path_1.default.join(path_1.default.dirname(require.resolve('react-native-windows/package.json', {
        paths: [process.cwd()],
    })), 'Scripts/rnw-dependencies.ps1');
    const rnwDeps = (0, child_process_1.execSync)(`${commandWithProgress_1.powershell} -ExecutionPolicy Unrestricted -NoProfile "${rnwDepScriptPath}" -NoPrompt -ListChecks`, { stdio: 'pipe' });
    const deps = rnwDeps.toString().trim().split('\n');
    const rnwHealthChecks = deps.map(dep => {
        const match = /([^:]+): ([^:]+): (.*)/.exec(dep);
        if (!match) {
            throw new Error(`Unexpected output from ${rnwDepScriptPath}`);
        }
        const [, optional, id, name] = match;
        return [optional.trim() === 'Required', id, name];
    });
    expect(healthCheckList_1.HealthCheckList).toEqual(rnwHealthChecks);
});
//# sourceMappingURL=healthChecks.test.js.map