"use strict";
/**
 * Copyright (c) Microsoft Corporation.
 * Licensed under the MIT License.
 * @format
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getHealthChecks = void 0;
const path_1 = __importDefault(require("path"));
const pathHelpers = __importStar(require("../../utils/pathHelpers"));
const rnDir = pathHelpers.resolveRnRoot(process.cwd());
const cliDir = pathHelpers.resolveRnCliRoot(rnDir);
const execaPath = require.resolve('execa', { paths: [cliDir] });
const execa = require(execaPath);
const commandWithProgress_1 = require("../../utils/commandWithProgress");
const healthCheckList_1 = require("./healthCheckList");
function getHealthChecks() {
    // #8471: There are known cases where the dependencies script will error out.
    // Fail gracefully if that happens in the meantime.
    try {
        return getHealthChecksUnsafe();
    }
    catch (_a) {
        return [
            {
                label: 'Windows',
                healthchecks: [
                    {
                        label: 'Failed to enumerate health checks',
                        description: 'Failed to enumerate health checks',
                        getDiagnostics: async () => ({ needsToBeFixed: true }),
                        runAutomaticFix: async ({ loader }) => {
                            loader.fail();
                        },
                    },
                ],
            },
        ];
    }
}
exports.getHealthChecks = getHealthChecks;
function getHealthChecksUnsafe() {
    // All our health checks are windows only...
    if (process.platform !== 'win32') {
        return undefined;
    }
    const rnwDepScriptPath = path_1.default.join(pathHelpers.resolveRnwRoot(process.cwd()), 'Scripts/rnw-dependencies.ps1');
    return [
        {
            label: 'Windows',
            healthchecks: healthCheckList_1.HealthCheckList.map((dep) => {
                const [optional, id, name] = dep;
                return {
                    label: name,
                    description: name,
                    // The schema check of react-native doctor requires this to be a string, although it should be a boolean
                    // Enable this once we pick up a new version of the CLI that includes https://github.com/react-native-community/cli/pull/1367
                    isRequired: optional,
                    getDiagnostics: async () => {
                        let needsToBeFixed = true;
                        try {
                            await execa(`"${commandWithProgress_1.powershell}" -ExecutionPolicy Unrestricted -NoProfile "${rnwDepScriptPath}" -NoPrompt -Check ${id}`);
                            needsToBeFixed = false;
                        }
                        catch (_a) { }
                        return {
                            needsToBeFixed,
                        };
                    },
                    runAutomaticFix: async ({ loader, logManualInstallation }) => {
                        const command = `${commandWithProgress_1.powershell} -ExecutionPolicy Unrestricted -NoProfile "${rnwDepScriptPath}" -Check ${id}`;
                        try {
                            const { exitCode } = await execa(command, { stdio: 'inherit' });
                            if (exitCode) {
                                logManualInstallation({
                                    command,
                                    healthcheck: `react-native-windows dependency "${id}"`,
                                });
                                loader.fail();
                            }
                            else {
                                loader.succeed();
                            }
                        }
                        catch (_a) {
                            logManualInstallation({
                                command,
                                healthcheck: `react-native-windows dependency "${id}"`,
                            });
                            loader.fail();
                        }
                    },
                };
            }),
        },
    ];
}
//# sourceMappingURL=healthChecks.js.map