import { __spreadArray } from "tslib";
import { timezones } from './timezones.generated';
import { hourCycles } from './hour-cycles.generated';
import { calendars } from './calendars.generated';
import { weekData } from './week-data.generated';
export function getCalendarPreferenceDataForRegion(region) {
    var _region = region ? region.toUpperCase() : null;
    return (calendars[(_region || '')] || calendars['001']).map(function (c) {
        // Resolve aliases
        // cldr-json/cldr-code v42.0.0-ALPHA3-2
        // https://github.com/unicode-org/cldr-json/blob/42.0.0-ALPHA3-2/cldr-json/cldr-bcp47/bcp47/calendar.json
        if (c === 'gregorian') {
            return 'gregory';
        }
        if (c === 'islamic-civil') {
            return 'islamicc';
        }
        // At the time this has been written this calendar was not listed in
        // the supplemental calendarPreferenceData file
        // https://github.com/unicode-org/cldr-json/blob/42.0.0-ALPHA3-2/cldr-json/cldr-core/supplemental/calendarPreferenceData.json
        // if (c === 'ethiopic-amete-alem') {
        //   return 'ethioaa'
        // }
        return c;
    });
}
export function getHourCyclesPreferenceDataForLocaleOrRegion(locale, region) {
    var _locale = locale.toLowerCase();
    var _region = (region ? region.toUpperCase() : '');
    var hourCyclesPreference = hourCycles[_locale] ||
        hourCycles[_region] ||
        hourCycles["".concat(_locale, "-001")] ||
        hourCycles['001'];
    return __spreadArray([], hourCyclesPreference, true);
}
export function getTimeZonePreferenceForRegion(region) {
    var territory = region.toLowerCase();
    if (timezones[territory]) {
        return __spreadArray([], timezones[territory], true);
    }
    return [];
}
export function getWeekDataForRegion(region) {
    var _region = (region ? region.toUpperCase() : '');
    return weekData[_region || '001'] || weekData['001'];
}
