// Type-only circular import
// eslint-disable-next-line import/no-cycle
var internalSlotMap = new WeakMap();
export default function getInternalSlots(x, internalSlotsList) {
    if (internalSlotsList === void 0) { internalSlotsList = []; }
    var internalSlots = internalSlotMap.get(x);
    if (!internalSlots) {
        internalSlots = Object.create(null, internalSlotsList.reduce(function (all, prop) {
            all[prop] = {
                enumerable: false,
                writable: true,
                configurable: true,
            };
            return all;
        }, {}));
        internalSlotMap.set(x, internalSlots);
    }
    return internalSlots;
}
