import { AzureLogger } from '@azure/logger';
import { Instrumentation } from '@opentelemetry/instrumentation';
import { InstrumentationConfig } from '@opentelemetry/instrumentation';

/**
 * Configuration options that can be passed to {@link createAzureSdkInstrumentation} function.
 */
export declare interface AzureSdkInstrumentationOptions extends InstrumentationConfig {
}

/**
 * Enables Azure SDK Instrumentation using OpenTelemetry for Azure SDK client libraries.
 *
 * When registered, any Azure data plane package will begin emitting tracing spans for internal calls
 * as well as network calls
 *
 * Example usage:
 * ```ts
 * const openTelemetryInstrumentation = require("@opentelemetry/instrumentation");
 * openTelemetryInstrumentation.registerInstrumentations({
 *   instrumentations: [createAzureSdkInstrumentation()],
 * })
 * ```
 *
 * @remarks
 *
 * As OpenTelemetry instrumentations rely on patching required modules, you should register
 * this instrumentation as early as possible and before loading any Azure Client Libraries.
 */
export declare function createAzureSdkInstrumentation(options?: AzureSdkInstrumentationOptions): Instrumentation;

/**
 * The \@azure/logger configuration for this package.
 */
export declare const logger: AzureLogger;

export { }
