// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import * as React from 'react';
import Svg, {type SvgProps, Path} from 'react-native-svg';

const Shield = (props: SvgProps) => (
    <Svg
        width={102}
        height={123}
        fill='none'
        {...props}
    >
        <Path
            fill='#CC8F00'
            d='m101.675 27.996-2.38-11.912a6.891 6.891 0 0 0-2.902-4.33C85.227 4.172 70.423.224 51.02.224 31.616.224 16.8 4.172 5.673 11.78a6.944 6.944 0 0 0-2.902 4.33L.337 27.996a4.072 4.072 0 0 0 .175 2.237c.267.715.73 1.344 1.337 1.817 3.209 2.461 4.667 5.712 5.349 9.819a30.225 30.225 0 0 1-.535 12.99c-9.936 38.395 6.793 55.861 44.29 67.918C88.396 110.72 105.166 93.254 95.23 54.86a30.444 30.444 0 0 1-.535-12.991c.735-4.107 2.193-7.358 5.349-9.82a4.112 4.112 0 0 0 1.407-1.795c.289-.717.367-1.5.224-2.258Z'
        />
        <Path
            fill='#FFBC1F'
            d='M51.02 113.063C16.946 101.507 8.054 87.108 15.81 57.124a39.17 39.17 0 0 0 .682-16.874A24.727 24.727 0 0 0 10.1 26.996l1.658-8.16C21.493 12.49 34.344 9.41 51.02 9.41c16.676 0 29.513 3.08 39.249 9.424l1.658 8.16a24.713 24.713 0 0 0-6.379 13.255 39.167 39.167 0 0 0 .682 16.874c7.716 29.97-1.136 44.449-35.21 55.939Z'
        />
        <Path
            fill='#FFBC1F'
            d='M51.02 113.063C16.946 101.507 8.054 87.108 15.81 57.124a39.17 39.17 0 0 0 .682-16.874A24.727 24.727 0 0 0 10.1 26.996l1.658-8.16C21.493 12.49 34.344 9.41 51.02 9.41c16.676 0 29.513 3.08 39.249 9.424l1.658 8.16a24.713 24.713 0 0 0-6.379 13.255 39.167 39.167 0 0 0 .682 16.874c7.716 29.97-1.136 44.449-35.21 55.939Z'
        />
        <Path
            fill='#FFBC1F'
            d='M51.02 52.452V9.438c-16.676 0-29.527 3.08-39.262 9.424l-1.658 8.16a24.727 24.727 0 0 1 6.392 13.255c.717 4.03.794 8.147.227 12.2l34.301-.025Z'
        />
        <Path
            fill='#FFBC1F'
            d='M51.02 113.063c34.073-11.49 42.926-25.969 35.21-55.94a41.203 41.203 0 0 1-.923-4.672H51.02v60.612Z'
        />
        <Path
            fill='#FFD470'
            d='M15.81 57.124c-7.756 29.983 1.137 44.383 35.21 55.939V52.451h-34.3a41.153 41.153 0 0 1-.91 4.673Z'
        />
        <Path
            fill='#FFD470'
            d='M51.02 9.438v43.04h34.287a38.483 38.483 0 0 1 .24-12.202 24.713 24.713 0 0 1 6.38-13.254l-1.659-8.16c-9.695-6.37-22.586-9.424-39.248-9.424Z'
        />
        <Path
            fill='#6F370B'
            d='M71.065 38.934 43.464 68.812l-8.01-5.976H31l12.463 19.915 32.054-43.817h-4.453Z'
        />
    </Svg>
);
export default Shield;
