// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import {type AppSchema, appSchema} from '@nozbe/watermelondb';

import {PlaybookRunSchema, PlaybookChecklistSchema, PlaybookChecklistItemSchema} from '@playbooks/database/schema';

import {
    CategorySchema,
    CategoryChannelSchema,
    ChannelSchema,
    ChannelBookmarkSchema,
    ChannelInfoSchema,
    ChannelMembershipSchema,
    ConfigSchema,
    CustomEmojiSchema,
    CustomProfileFieldSchema,
    CustomProfileAttributeSchema,
    DraftSchema,
    FileSchema,
    GroupSchema,
    GroupChannelSchema,
    GroupMembershipSchema,
    GroupTeamSchema,
    MyChannelSchema,
    MyChannelSettingsSchema,
    MyTeamSchema,
    PostInThreadSchema,
    PostSchema,
    PostsInChannelSchema,
    PreferenceSchema,
    ReactionSchema,
    RoleSchema,
    ScheduledPostSchema,
    SystemSchema,
    TeamChannelHistorySchema,
    TeamMembershipSchema,
    TeamSchema,
    TeamSearchHistorySchema,
    ThreadSchema,
    ThreadInTeamSchema,
    ThreadParticipantSchema,
    TeamThreadsSyncSchema,
    UserSchema,
} from './table_schemas';

export const serverSchema: AppSchema = appSchema({
    version: 12,
    tables: [
        CategorySchema,
        CategoryChannelSchema,
        ChannelSchema,
        ChannelBookmarkSchema,
        ChannelInfoSchema,
        ChannelMembershipSchema,
        ConfigSchema,
        CustomEmojiSchema,
        CustomProfileFieldSchema,
        CustomProfileAttributeSchema,
        DraftSchema,
        FileSchema,
        GroupSchema,
        GroupChannelSchema,
        GroupMembershipSchema,
        GroupTeamSchema,
        MyChannelSchema,
        MyChannelSettingsSchema,
        MyTeamSchema,
        PlaybookRunSchema,
        PlaybookChecklistSchema,
        PlaybookChecklistItemSchema,
        PostInThreadSchema,
        PostSchema,
        PostsInChannelSchema,
        PreferenceSchema,
        ReactionSchema,
        RoleSchema,
        ScheduledPostSchema,
        SystemSchema,
        TeamChannelHistorySchema,
        TeamMembershipSchema,
        TeamSchema,
        TeamSearchHistorySchema,
        TeamThreadsSyncSchema,
        ThreadSchema,
        ThreadInTeamSchema,
        ThreadParticipantSchema,
        UserSchema,
    ],
});
