import { collations } from './collations.generated';
function isSupported(collation, locale) {
    if (locale === void 0) { locale = 'en'; }
    try {
        return (Intl.Collator("".concat(locale, "-u-co-").concat(collation)).resolvedOptions()
            .collation === collation);
    }
    catch (_err) { }
    return false;
}
export function getSupportedCollations(locale) {
    return collations.filter(function (collation) { return isSupported(collation, locale); });
}
