// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import {defineConfig} from 'eslint/config';
import headerPlugin from "eslint-plugin-header";
import tseslint from "@typescript-eslint/eslint-plugin";
import stylisticTs from "@stylistic/eslint-plugin-ts";

headerPlugin.rules.header.meta.schema = false;

export default defineConfig([
  {
    files: ["**/*.{js,jsx,ts,tsx}"],
    languageOptions: {
      ecmaVersion: 8,
      sourceType: "module",
      globals: {
        browser: true,
        node: true,
        jquery: true,
        es6: true
      },
    },
    plugins: {
      header: headerPlugin,
      "@typescript-eslint": tseslint,
      "@stylistic/ts": stylisticTs,
    },
    rules: {
      "array-bracket-spacing": [2, "never"],
      "array-callback-return": 2,
      "arrow-body-style": 0,
      "arrow-parens": [2, "always"],
      "arrow-spacing": [2, { before: true, after: true }],
      "block-scoped-var": 2,
      "brace-style": [2, "1tbs", { allowSingleLine: false }],
      "camelcase": [2, { properties: "never" }],
      "capitalized-comments": 0,
      "class-methods-use-this": 0,
      "comma-dangle": [2, "always-multiline"],
      "comma-spacing": [2, { before: false, after: true }],
      "comma-style": [2, "last"],
      "complexity": [0, 10],
      "computed-property-spacing": [2, "never"],
      "consistent-return": 2,
      "consistent-this": [2, "self"],
      "constructor-super": 2,
      "curly": [2, "all"],
      "dot-location": [2, "object"],
      "dot-notation": 2,
      "eqeqeq": [2, "smart"],
      "func-call-spacing": [2, "never"],
      "func-name-matching": 0,
      "func-names": 2,
      "func-style": [2, "declaration", { allowArrowFunctions: true }],
      "generator-star-spacing": [2, { before: false, after: true }],
      "global-require": 2,
      "guard-for-in": 2,
      "header/header": [
          2,
          "line",
          " Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.\n See LICENSE.txt for license information."
      ],
      "id-blacklist": 0,
      "indent": [2, 4, { SwitchCase: 0 }],
      "jsx-quotes": [2, "prefer-single"],
      "key-spacing": [2, { beforeColon: false, afterColon: true, mode: "strict" }],
      "keyword-spacing": [2, { before: true, after: true, overrides: {} }],
      "line-comment-position": 0,
      "linebreak-style": 2,
      "lines-around-comment": [2, { beforeBlockComment: true, beforeLineComment: true, allowBlockStart: true, allowBlockEnd: true }],
      "max-lines": [1, { max: 550, skipBlankLines: true, skipComments: true }],
      "max-nested-callbacks": [2, { max: 2 }],
      "max-statements-per-line": [2, { max: 1 }],
      "multiline-ternary": [1, "never"],
      "new-cap": 2,
      "new-parens": 2,
      "newline-before-return": 0,
      "newline-per-chained-call": 0,
      "no-alert": 2,
      "no-array-constructor": 2,
      "no-await-in-loop": 2,
      "no-caller": 2,
      "no-case-declarations": 2,
      "no-class-assign": 2,
      "no-compare-neg-zero": 2,
      "no-cond-assign": [2, "except-parens"],
      "no-confusing-arrow": 2,
      "no-console": 2,
      "no-const-assign": 2,
      "no-constant-condition": 2,
      "no-debugger": 2,
      "no-div-regex": 2,
      "no-dupe-args": 2,
      "no-dupe-class-members": 2,
      "no-dupe-keys": 2,
      "no-duplicate-case": 2,
      "no-duplicate-imports": [2, { includeExports: true }],
      "no-else-return": 2,
      "no-empty": 2,
      "no-empty-function": 2,
      "no-empty-pattern": 2,
      "no-eval": 2,
      "no-ex-assign": 2,
      "no-extend-native": 2,
      "no-extra-bind": 2,
      "no-extra-label": 2,
      "no-extra-parens": 0,
      "no-extra-semi": 2,
      "no-fallthrough": 2,
      "no-floating-decimal": 2,
      "no-func-assign": 2,
      "no-global-assign": 2,
      "no-implicit-coercion": 2,
      "no-implicit-globals": 0,
      "no-implied-eval": 2,
      "no-inner-declarations": 0,
      "no-invalid-regexp": 2,
      "no-irregular-whitespace": 2,
      "no-iterator": 2,
      "no-labels": 2,
      "no-lone-blocks": 2,
      "no-lonely-if": 2,
      "no-loop-func": 2,
      "no-magic-numbers": 0,
      "no-mixed-operators": [2, { allowSamePrecedence: false }],
      "no-mixed-spaces-and-tabs": 2,
      "no-multi-assign": 2,
      "no-multi-spaces": [2, { exceptions: { Property: false } }],
      "no-multiple-empty-lines": [2, { max: 1 }],
      "no-native-reassign": 2,
      "no-negated-condition": 2,
      "no-nested-ternary": 2,
      "no-new": 2,
      "no-new-func": 2,
      "no-new-object": 2,
      "no-new-symbol": 2,
      "no-new-wrappers": 2,
      "no-octal-escape": 2,
      "no-param-reassign": 2,
      "no-process-env": 2,
      "no-prototype-builtins": 1,
      "no-redeclare": 0,
      "no-return-assign": [2, "always"],
      "no-return-await": 2,
      "no-script-url": 2,
      "no-self-assign": [2, { props: true }],
      "no-self-compare": 2,
      "no-sequences": 2,
      "no-shadow": [2, { hoist: "functions" }],
      "no-shadow-restricted-names": 2,
      "no-spaced-func": 2,
      "no-tabs": 0,
      "no-ternary": 0,
      "no-this-before-super": 2,
      "no-throw-literal": 2,
      "no-trailing-spaces": [2, { skipBlankLines: false }],
      "no-undef-init": 2,
      "no-undefined": 2,
      "no-underscore-dangle": 2,
      "no-unexpected-multiline": 2,
      "no-unmodified-loop-condition": 2,
      "no-unneeded-ternary": [2, { defaultAssignment: false }],
      "no-unreachable": 2,
      "no-unused-expressions": 2,
      "no-use-before-define": [2, { classes: false, functions: false, variables: false }],
      "no-useless-computed-key": 2,
      "no-useless-concat": 2,
      "no-useless-constructor": 2,
      "no-useless-return": 2,
      "no-var": 0,
      "no-void": 2,
      "no-warning-comments": 1,
      "no-whitespace-before-property": 2,
      "no-with": 2,
      "object-curly-spacing": [2, "never"],
      "object-property-newline": [2, { allowMultiplePropertiesPerLine: true }],
      "object-shorthand": [2, "always"],
      "one-var": [2, "never"],
      "prefer-arrow-callback": 2,
      "prefer-const": 2,
      "prefer-numeric-literals": 2,
      "prefer-promise-reject-errors": 2,
      "quotes": [2, "single", "avoid-escape"],
      "semi": [2, "always"],
      "semi-spacing": [2, { before: false, after: true }],
      "space-before-blocks": [2, "always"],
      "space-in-parens": [2, "never"],
      "@typescript-eslint/array-type": [2, { default: "array-simple" }],
      "@stylistic/ts/member-delimiter-style": 2,
      "@stylistic/ts/type-annotation-spacing": 2,
      "@typescript-eslint/no-redeclare": [
        2,
        { ignoreDeclarationMerge: true }
      ]
    },
  },
    // Jest Config
]);

export const jestConfig = defineConfig({
  files: ["**/*.test.{js,jsx,ts,tsx}", "**/tests/**"],
  languageOptions: {
    globals: {
      after: true,
      afterAll: true,
      afterEach: true,
      before: true,
      beforeAll: true,
      beforeEach: true,
      describe: true,
      expect: true,
      it: true,
      jest: true,
      test: true
    }
  },
  rules: {
    "no-empty-function": "off",
    "no-console": "off",
    "max-nested-callbacks": "off",
    "no-undefined": 'off'
  }
});
