// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.

import * as React from 'react';
import Svg, {type SvgProps, Path, Ellipse} from 'react-native-svg';

const EmptyIllustration = (props: SvgProps) => (
    <Svg
        width={140}
        height={141}
        fill='none'
        {...props}
    >
        <Path
            fill='#A4A9B7'
            d='m55.88 90.14-.188.188-.73.917a38.086 38.086 0 0 1-3.127 3.127l-2.022 1.846-10.288 9.007-12.133 9.736a1.183 1.183 0 0 1-1.32.038 1.193 1.193 0 0 1-.338-.319 1.356 1.356 0 0 1-.177-1.741l3.67-4.597L42.088 93.09l4.045-4.597a583.82 583.82 0 0 0 2.94-2.94l1.292-1.105c.822-.6 1.83-.89 2.845-.823a3.512 3.512 0 0 1 2.575 1.292 3.92 3.92 0 0 1 1.042 2.565 4.566 4.566 0 0 1-.948 2.658Z'
        />
        <Path
            fill='#E8E9ED'
            d='m36.68 102.268 12.134-14.635 2.118 1.155-14.252 13.48Z'
        />
        <Path
            fill='#FFBC1F'
            d='M114.68 58.626a3.58 3.58 0 0 1-1.105 2.659l-1.282 1.292a10.205 10.205 0 0 1-14.333 0 .46.46 0 0 0-.74 0L81.97 77.641a2.814 2.814 0 0 0-.187 3.68 13.657 13.657 0 0 1 2.303 9.007 14.01 14.01 0 0 1-3.95 8.454l-5.88 5.88a8.217 8.217 0 0 1-11.58 0L35.657 77.828a8.215 8.215 0 0 1 0-11.581l6.067-5.88a13.134 13.134 0 0 1 8.454-4.045c3.185-.242 6.359.6 9.006 2.388a2.71 2.71 0 0 0 3.492-.365l15.229-15.043a.782.782 0 0 0 0-.74 10.206 10.206 0 0 1 0-14.334l1.105-1.283a4.242 4.242 0 0 1 2.846-1.105 3.627 3.627 0 0 1 2.668 1.105l29.03 29.033a3.604 3.604 0 0 1 1.126 2.648Z'
        />
        <Path
            fill='#FFD470'
            d='M69.036 71.843c-6.317-6.317-8.025-10.72-8.09-12.132-8.473-3.659-9.051-2.118-5.007 2.503 4.116 4.703 20.993 17.524 13.097 9.629ZM71.13 66.07a3.013 3.013 0 0 1-2.21.917 2.968 2.968 0 0 1-2.2-.918 2.909 2.909 0 0 1-.917-2.085c.021-.852.347-1.67.917-2.303l12.123-11.937a3.033 3.033 0 0 1 5.15 2.085 2.93 2.93 0 0 1-.918 2.085L71.13 66.05v.02Z'
        />
        <Path
            fill='#F5AB00'
            d='m95.21 60.59-1.866-1.905C82.746 48.164 76.082 46.6 74 47.203l4.172-3.998 15.172 15.48c.609.605 1.231 1.24 1.866 1.905Z'
        />
        <Ellipse
            cx={59}
            cy={115}
            fill='#000'
            fillOpacity={0.06}
            rx={34}
            ry={2.5}
        />
    </Svg>
);
export default EmptyIllustration;
