// Copyright (c) 2015-present Mattermost, Inc. All Rights Reserved.
// See LICENSE.txt for license information.
import * as React from 'react';
import Svg, {
    Path,
    Mask,
    G,
    Rect,
} from 'react-native-svg';

type Props = {
    theme: Theme;
}

function ReviewAppIllustration({theme}: Props) {
    return (
        <Svg
            width={222}
            height={205}
            viewBox='0 0 222 205'
            fill='none'
        >
            <Path
                d='M166.305 43.157c0-3.319 2.79-6.01 6.232-6.01h43.231c3.442 0 6.232 2.691 6.232 6.01v41.69c0 3.32-2.79 6.01-6.232 6.01h-43.231c-3.442 0-6.232-2.69-6.232-6.01v-41.69Z'
                fill={theme.centerChannelColor}
                fillOpacity={0.08}
            />
            <Path
                d='M194.309 76.927a.835.835 0 0 0-.517 0l-11.006 4.04a.914.914 0 0 1-.75-.118.7.7 0 0 1-.302-.618l.6-11.294a.854.854 0 0 0-.171-.496l-7.394-8.828a.652.652 0 0 1-.157-.313.63.63 0 0 1 .03-.346.913.913 0 0 1 .469-.496l11.435-2.968c.09 0 .178-.024.255-.067a.496.496 0 0 0 .184-.181l6.447-9.483a.775.775 0 0 1 .28-.24.804.804 0 0 1 1.009.24l6.447 9.483a.525.525 0 0 0 .171.224c.078.059.17.096.267.108l11.352 2.884c.124.04.238.105.334.19a.89.89 0 0 1 .223.305.64.64 0 0 1-.127.66l-7.394 8.828a.813.813 0 0 0-.175.495l.604 11.295a.65.65 0 0 1-.083.355.695.695 0 0 1-.263.263.86.86 0 0 1-.688.122L194.3 76.93l.009-.004Z'
                fill='#FFBC1F'
            />
            <Rect
                x={95.794}
                y={168.252}
                width={19.722}
                height={3.26}
                rx={1.63}
                fill='#8D93A5'
            />
            <Path
                fillRule='evenodd'
                clipRule='evenodd'
                d='M144.9 178.534c-2.206 2.177-5.351 3.846-8.8 3.846H75.773c-3.449 0-6.593-1.669-8.799-3.846-2.21-2.182-3.863-5.252-3.863-8.573V35.039c0-3.322 1.65-6.392 3.86-8.574 2.205-2.178 5.349-3.845 8.797-3.845H136.1c3.448 0 6.593 1.666 8.799 3.844 2.212 2.182 3.863 5.252 3.863 8.575v134.922c0 3.321-1.652 6.391-3.862 8.573Zm-8.8.586c4.641 0 9.281-4.585 9.281-9.159V35.039c0-4.58-4.64-9.159-9.281-9.159H75.768c-4.64 0-9.276 4.58-9.276 9.16V169.96c0 4.574 4.64 9.159 9.281 9.159H136.1Z'
                fill='#363A45'
            />
            <Path
                d='M145.381 169.961c0 4.574-4.64 9.159-9.281 9.159H75.773c-4.64 0-9.28-4.585-9.28-9.159V35.039c0-4.58 4.634-9.159 9.275-9.159H136.1c4.641 0 9.281 4.58 9.281 9.16V169.96Z'
                fill='#3F4350'
            />
            <Path
                d='M112.699 33.758c0 .451-.296.817-.671.817H99.851c-.37 0-.676-.377-.676-.817 0-.44.307-.814.676-.814h12.157c.374 0 .691.366.691.814Z'
                fill='#8D93A5'
            />
            <Path
                fill={theme.centerChannelBg}
                d='M69.873 42.726H142v120.092H69.873z'
            />
            <Mask
                id='a'
                maskUnits='userSpaceOnUse'
                x={69}
                y={43}
                width={134}
                height={120}
            >
                <Path
                    fill='#FFFFFF'
                    d='M69.716 43.157h132.421v119.812H69.716z'
                />
            </Mask>
            <G mask='url(#a)'>
                <Path
                    d='m89.041 85.762.504-14.438-1.145-5.718c2.096-5.199 5.176-4.835 7.066-5 4.306-.376 7.18-2.65 9.161-.64 1.077 1.203 2.291 6.115 2.485 9.934.138 2.02.871 3.742-.687 4.757a21.35 21.35 0 0 1-3.355 1.413l.572 10.807-14.6-1.115Z'
                    fill='#AD831F'
                />
                <Path
                    d='M105.784 65.33a21.555 21.555 0 0 1 3.882 3.312c.355 1.512-3.962 2.285-3.962 2.285l.08-5.597Z'
                    fill='#AD831F'
                />
                <Path
                    d='M98.489 76.644c1.527.161 3.072-.024 4.512-.54.538-.21-.996.728-1.546.916-.707.35-1.498.51-2.29.463-.55-.088-1.26-.883-.676-.839Z'
                    fill='#7A5600'
                />
                <Path
                    d='M110.433 58.243a1.927 1.927 0 0 0-.966-.99 2.036 2.036 0 0 0-1.404-.113c-4.066.65-3.298-2.76-9.288-1.789-4.168.674-8.566 0-12.253 2.043a7.734 7.734 0 0 0-3.619 3.465 3.458 3.458 0 0 0-.21 2.424 3.58 3.58 0 0 0 1.447 1.992c.252.143.55.265.676.519.08.264.056.547-.069.794-.515 1.49-.973 3.312.183 4.416.642.618 1.718.905 1.97 1.744.137.463 0 .96.057 1.446.24 1.28 2.29 1.49 3.264.585a5.392 5.392 0 0 0 1.271-3.643c.103-1.159.137-2.494-.756-3.311-.412-.376-.996-.596-1.214-1.104a1.45 1.45 0 0 1 .046-.93c.118-.298.33-.552.607-.726a3.237 3.237 0 0 1 1.24-.505 3.29 3.29 0 0 1 1.346.036c.44.105.853.299 1.209.57.356.272.647.614.855 1.003.332.728.435 1.689 1.145 2.042.927.442 1.98-.552 2.107-1.534a16.322 16.322 0 0 0-.31-2.959c0-.993.527-2.207 1.558-2.207.34.017.677.084.996.198 2.023.55 4.157.603 6.207.155a6.497 6.497 0 0 0 2.817-1.104c.402-.284.716-.669.908-1.112.191-.444.254-.93.18-1.405Z'
                    fill='#4A2407'
                />
                <Path
                    d='m102.577 64.403.058-.11c-3.058-.266-6.872-.497-9.483-.464-2.61.033-3.813.386-5.176 2.65-.229.385.436.661.676.275.27-.62.715-1.154 1.284-1.544a3.846 3.846 0 0 1 1.934-.664c1.328-.099 2.703 0 4.02 0 1.683 0 4.294.232 6.47.43.068-.198.137-.385.217-.573Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M102.978 66.555a2.144 2.144 0 0 1-.751-.944 2.064 2.064 0 0 1-.108-1.186c.161-1.16 1.054-1.998 1.981-1.877.499.137.922.456 1.181.889s.332.945.205 1.43c-.16 1.103-1.053 1.998-1.981 1.876a1.311 1.311 0 0 1-.527-.188Zm1.374-3.311a.687.687 0 0 0-.32-.11c-.63-.089-1.237.54-1.363 1.401-.126.861.286 1.634.916 1.722.63.089 1.225-.552 1.351-1.413.078-.299.064-.613-.04-.905a1.595 1.595 0 0 0-.544-.74v.045Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M97.344 84.824c29.774.22 29.694-2.473 32.683 31.382 2.989 33.854 3.035 35.08-26.408 36.945-19.628 1.248-31.217 8.831-32.236-1.567-1.03-10.597-1.683-10.288-3.436-28.292-3.973-39.837-3.298-38.711 29.397-38.468Z'
                    fill='#AD831F'
                />
                <Path
                    d='M110.72 109.848c8.497 9.294 27.69 16.48 42.52 16.48a24.612 24.612 0 0 0 6.275-.773 21.401 21.401 0 0 0 3.653-1.313c12.208-5.751 15.838-23.501 18.495-29.594 3.275-7.495-.126-2.837 2.084-7.12.79-1.534 2.737-2.528 3.367-3.311.904-1.104-.825-2.594-7.352 1.666-10.307 6.624-9.162 19.969-19.308 21.371a15.88 15.88 0 0 1-3.836 0 25.19 25.19 0 0 1-3.378-.585c-18.105-4.305-19.64-20.796-37.459-21.47 0-.044-13.57 15.288-5.061 24.649ZM17.629 97.452c-.344.927 1.145 5.519 1.546 9.724.985 10.134 4.214 25.687 19.216 31.625a18.309 18.309 0 0 0 5.966 1.215c1.3.055 2.604-.004 3.894-.177 9.16-1.104 19.227-7.539 24.22-17.573 6.87-13.853 9.665-37.354 9.665-37.354-6.619 0-22.903-1.225-28.824 23.986a13.288 13.288 0 0 1-2.394 5.456 13.886 13.886 0 0 1-4.58 3.949 10.907 10.907 0 0 1-3.642 1.104 9.984 9.984 0 0 1-5.085-.698 9.604 9.604 0 0 1-3.996-3.11c-8.886-11.469-9.986-23.81-16.387-25.024-6.402-1.215 2.073 2.362.4 6.877Z'
                    fill='#AD831F'
                />
                <Path
                    d='M115.781 85.155c17.819.673 19.354 17.165 37.459 21.47 1.889.483 3.839.713 5.794.684.836 5.883 1.443 11.8 2.027 17.728a24.098 24.098 0 0 1-7.821 1.247c-14.83 0-34.023-7.186-42.52-16.491-8.498-9.306 5.061-24.638 5.061-24.638ZM44.804 118.932c3.825-1.247 7.26-4.647 8.508-10.034 5.875-25.211 22.205-23.997 28.813-23.986 0 0-2.76 23.501-9.654 37.354-5.566 11.171-17.36 17.827-27.324 17.761a69.32 69.32 0 0 0-.343-21.095Z'
                    fill='#1E325C'
                />
                <Path
                    d='M131.355 135.92c17.361 49.055 18.415 69.2 16.8 86.099-1.615 16.9-14.406 34.286-31.091 47.013-3.516 2.406-7.913 4.106-5.131 10.663 4.043 9.537-6.596-2.992-9.253-9.228-2.656-6.237 25.515-17.088 19.01-50.39-6.504-33.303-23.957-46.924-34.87-70.491-10.914-23.567 44.535-13.666 44.535-13.666Z'
                    fill={theme.buttonBg}
                />
                <Path
                    d='M131.355 135.92c17.361 49.055 18.415 69.2 16.8 86.099-1.615 16.9-14.406 34.286-31.091 47.013-3.516 2.406-7.913 4.106-5.131 10.663 4.043 9.537-6.596-2.992-9.253-9.228-2.656-6.237 25.515-17.088 19.01-50.39-6.504-33.303-23.957-46.924-34.87-70.491-10.914-23.567 44.535-13.666 44.535-13.666Z'
                    fill='#000'
                    fillOpacity={0.16}
                />
                <Path
                    d='M111.086 139.188c2.107 54.971-3.355 80.26-28.057 98.042-24.701 17.783-43.848 18.423-44.593 27.386-.744 8.964-2.977 6.91-3.847-2.285-1.145-12.484-6.55-3.212 22.159-24.56 28.71-21.348 15.15-77.599 13.742-94.267-1.409-16.668 40.596-4.316 40.596-4.316Z'
                    fill={theme.buttonBg}
                />
                <Path
                    d='M38.081 255.466c14.407-6.844 29.385-14.472 36.073-29.418 7.444-16.634 4.272-35.322 3.802-52.785-.275-10.531 0-21.072.71-31.581 0-.474.802-.474.767 0-.607 9.659-.927 19.328-.755 29.009.171 9.681 1.145 19.361 1.145 29.064-.057 8.4-1.008 16.922-4.157 24.814-2.898 7.177-7.71 13.491-13.948 18.302-6.997 5.519-15.14 9.416-23.19 13.246-.504.199-.893-.442-.447-.651Z'
                    fill='#1E325C'
                />
                <Path
                    d='M89.099 84.769a6.29 6.29 0 0 0 3.126 2.55c4.707 1.865 10.696 1.865 13.33-2.473 21.643 0 21.838.927 24.518 31.36 1.351 15.299 2.096 23.931-.195 28.976-11.944 4.978-25.675 6.623-38.191 8.963-5.451 1.015-10.925 1.876-16.41 2.638-2.222-.519-3.54-2.009-3.848-5.199-1.03-10.597-1.684-10.288-3.436-28.292-3.653-36.14-3.435-38.567 21.106-38.523Z'
                    fill={theme.centerChannelBg}
                />
                <Path
                    d='M89.099 84.769a6.29 6.29 0 0 0 3.126 2.55c4.707 1.865 10.696 1.865 13.33-2.473 21.643 0 21.838.927 24.518 31.36 1.351 15.299 2.096 23.931-.195 28.976-11.944 4.978-25.675 6.623-38.191 8.963-5.451 1.015-10.925 1.876-16.41 2.638-2.222-.519-3.54-2.009-3.848-5.199-1.03-10.597-1.684-10.288-3.436-28.292-3.653-36.14-3.435-38.567 21.106-38.523Z'
                    fill={theme.centerChannelColor}
                    fillOpacity={0.08}
                />
                <Path
                    d='M118.198 142.775a81.05 81.05 0 0 1-7.662-18.412 215.276 215.276 0 0 1-6.252-39.528c22.903 0 25.193-.806 27.976 30.212.138 1.501-1.672 4.194-1.145 5.729 4.432 11.987 20.304 24.284 18.998 27.044-1.82 3.951-8.772 8.168-17.521 11.48a77.847 77.847 0 0 1-6.985 1.368 104.902 104.902 0 0 0-7.409-17.893ZM67.764 145.546c-.653 7.34-1.511 13.621-.973 19.24 5.027-.806 10.077-1.314 15.15-1.656a100.117 100.117 0 0 0 9.826-35.511c.664-7.34 2.714-35.532 2.21-39.738-.32-2.825-3.974-.441-4.718-3.135-24.69 0-27.335 1.767-23.716 37.983.171 1.811 2.702 4.107 2.782 5.818.206 5.672.019 11.351-.56 16.999Z'
                    fill='#1E325C'
                />
                <Path
                    d='M105.864 83.422c1.695 1.314 1.386.95.229 3.013-1.157 2.065-1.741 3.93-2.691 1.424-.951-2.505-1.077-2.108.16-3.598 1.237-1.49 1.443-1.512 2.302-.84ZM91.687 83.841c3.836 1.623 2.428 1.248 3.16 3.687 1.592 5.243-.63 2.462-6.069-.563-3.699-2.064-3.264-2.384-1.97-3.642 1.294-1.259.905-1.204 4.673.518 3.767 1.722-3.642-1.59.206 0ZM156.618 107.21a214.295 214.295 0 0 0 2.897 18.301 21.401 21.401 0 0 0 3.653-1.313 203.658 203.658 0 0 1-2.714-16.999 15.88 15.88 0 0 1-3.836.011Z'
                    fill={theme.buttonBg}
                />
            </G>
            <Path
                d='M25.705 125.411c0-3.319 2.79-6.01 6.232-6.01h18.305c3.442 0 6.232 2.691 6.232 6.01v17.652c0 3.319-2.79 6.01-6.232 6.01H31.937c-3.442 0-6.232-2.691-6.232-6.01v-17.652Z'
                fill={theme.centerChannelColor}
                fillOpacity={0.08}
            />
            <Path
                d='M31.28 134.233s.33-3.798 2.412-5.711c2.081-1.914 4.073-3.181 8.275-3.428 4.202-.247 6.836 3.841 7.243 4.57.408.729 1.617 2.892 1.617 4.569 0 1.676.013 5.199-2.478 6.763-2.492 1.564-4.889 2.476-6.608 2.389-1.72-.086-6.066-.433-8.014-3.042-1.947-2.608-2.447-3.442-2.447-6.11Z'
                fill='#FFBC1F'
            />
            <Path
                d='M41.394 127.066a3.612 3.612 0 0 1 2.646.289.125.125 0 0 0 .145-.017.115.115 0 0 0 .022-.14c-.37-.652-1.336-1.841-2.928-.329a.114.114 0 0 0-.037.067.119.119 0 0 0 .073.125c.025.01.053.011.079.005Z'
                fill='#FFD470'
            />
            <Path
                d='M37.474 141.656c-1.019-1.004-2.376-2.281-2.24-6.648.136-4.368 1.223-5.914 2.001-7.075.419-.63 1.895-1.933 3.703-2.753-3.519.384-5.35 1.593-7.257 3.342-2.091 1.911-2.411 5.709-2.411 5.709 0 2.668.51 3.504 2.457 6.11 1.948 2.607 6.292 2.956 8.014 3.042-.002 0-3.248-.717-4.267-1.727Z'
                fill='#CC8F00'
            />
            <Path
                d='M42.017 140.642s5.438.099 6.392-4.787a.64.64 0 0 0-.118-.519.681.681 0 0 0-.21-.183.72.72 0 0 0-.268-.087 54.746 54.746 0 0 0-12.165.177.698.698 0 0 0-.462.267.65.65 0 0 0-.116.506c.264 1.363 1.465 4.307 6.947 4.626Z'
                fill='#6F370B'
            />
            <Path
                d='M42.607 140.287s-3.322.239-4.709-1.096l.168-.121c.179-.102.37-.181.57-.237a4.687 4.687 0 0 1 1.068-.165c.209-.01.418-.014.638 0 .22.002.44.033.652.091.21.065.412.152.603.257.285.144.536.343.736.586.157.199.252.436.274.685Z'
                fill='#C43133'
            />
            <Path
                d='M36.961 135.389s4.755-.283 10.074-.174c0 0-.272 1.022-5.183 1.022-1.109 0-4.686.413-4.89-.848Z'
                fill='#fff'
            />
            <Path
                d='M39.256 131.17c.052 1.169-.418 2.137-1.063 2.163-.644.026-1.198-.9-1.255-2.068-.056-1.169.419-2.135 1.063-2.161.644-.026 1.205.896 1.255 2.066ZM46.498 131.176c.046 1.022-.37 1.87-.931 1.894-.56.024-1.046-.787-1.094-1.807-.048-1.02.37-1.87.93-1.894.561-.024 1.049.785 1.095 1.807Z'
                fill='#6F370B'
            />
            <Path
                d='M0 66.444c0-3.32 2.79-6.01 6.232-6.01h36.22c3.442 0 6.232 2.69 6.232 6.01v34.929c0 3.319-2.79 6.01-6.231 6.01H6.232c-3.442 0-6.232-2.691-6.232-6.01v-34.93Z'
                fill={theme.centerChannelColor}
                fillOpacity={0.08}
            />
            <Path
                d='M34.592 95.28s-3.856 1.454-4.48 1.671c-.623.217-2.508.983-2.956 1.126-.448.144-3.102 1.126-4.118 1.126-1.017 0-4.608-.4-4.608-.4l-2.133-.906-.754-1.126-.493-.719-1.647-1.416v-2.259l.262-.581-1.086-1.377-.345-2.034.748-1.634.19-.689-1.237-2.395.71-1.597s1.874-1.233 2.136-1.307a13.832 13.832 0 0 1 2.543 0c1.978.082 3.959.063 5.934-.056 1.444-.127 1.034-.902 1.034-.902l-1.475-3.108-.561-3.448s-.149-1.597.151-2.395c.3-.799 1.61-1.962 2.919-1.888 1.31.073.6 1.56.6 1.56l1.123 1.925s.748.668.861 1.052c.114.384.562 2.322.9 3.341.338 1.02 1.533 3.124 2.919 4.01 1.385.885 4.007 2.322 4.455 3.084.318.61.557 1.256.71 1.924l.345 2.339-.262 2.252-.758 3.124-1.627 1.704Z'
                fill='#FFBC1F'
            />
            <Path
                d='M25.88 80.546s-3.704-2.65-3.445-9.689c0 0-1.496 5.56 1.199 9.803-.01-.004 1.485.247 2.247-.114ZM15.612 80.71s-2.499.732-2.647 2.279c-.148 1.546 0 2.566.948 3.244 0 0-2.995 3.34.344 5.516 0 0-2.047 3.725 1.847 4.26 0 0-1.278 3.097 5.9 2.903a16.222 16.222 0 0 0 7.478-2.131c1.034-.578 3.394-1.257 4.135-1.788.741-.531 2.809-2.275 3.046-5.713 0-1.985 0-3.846-.475-5.346 0 0 1.347 1.337 1.347 4.297s-.723 5.42-1.423 6.458c-.7 1.04-2.068 2.105-3.37 2.339-1.303.234-2.757.217-3.69.628-.935.411-3.447 1.38-5.442 1.574-2.118.127-4.244.03-6.34-.29-.849-.195-2.572-1.26-2.472-2.674 0 0-3.494-1.26-1.599-4.343 0 0-1.67-.822-1.67-3.12a2.91 2.91 0 0 1 .34-1.285c.212-.398.514-.745.882-1.014a3.355 3.355 0 0 1-1.25-1.306 3.227 3.227 0 0 1-.373-1.745c.166-2.158 2.437-2.967 4.484-2.743Z'
                fill='#CC8F00'
            />
            <Path
                d='M27.838 73.31a4.725 4.725 0 0 1-2.007-1.786 4.521 4.521 0 0 1-.674-2.558c0-.361.917-.401 1.068 0 .152.4 1.523 3.782 1.613 4.343Z'
                fill='#FFD470'
            />
        </Svg>
    );
}

export default ReviewAppIllustration;
