package com.matedroid.ui.theme

import androidx.compose.ui.graphics.Color

// Neutral base colors (cool grey/blue-grey - works with any car color)
val NeutralPrimary = Color(0xFF5C6670)
val NeutralDark = Color(0xFF1C1F23)

// Status colors (semantic - always fixed)
val StatusSuccess = Color(0xFF4CAF50)
val StatusWarning = Color(0xFFFF9800)
val StatusError = Color(0xFFF44336)

// Light theme colors - neutral cool grey
val PrimaryLight = Color(0xFF5C6670)
val OnPrimaryLight = Color.White
val PrimaryContainerLight = Color(0xFFE8EAEC)
val OnPrimaryContainerLight = Color(0xFF1C1F23)
val SecondaryLight = Color(0xFF5C6670)
val OnSecondaryLight = Color.White
val SecondaryContainerLight = Color(0xFFE2E4E6)
val OnSecondaryContainerLight = Color(0xFF1B1D1F)
val TertiaryLight = Color(0xFF6B7A8C)
val OnTertiaryLight = Color.White
val BackgroundLight = Color(0xFFFAFAFA)
val OnBackgroundLight = Color(0xFF1C1B1F)
val SurfaceLight = Color(0xFFFAFAFA)
val OnSurfaceLight = Color(0xFF1C1B1F)
val SurfaceVariantLight = Color(0xFFE8EAEC)
val OnSurfaceVariantLight = Color(0xFF44474A)
val ErrorLight = StatusError
val OnErrorLight = Color.White

// Dark theme colors - neutral cool grey
val PrimaryDark = Color(0xFF9BA4AD)
val OnPrimaryDark = Color(0xFF1C1F23)
val PrimaryContainerDark = Color(0xFF3A3F44)
val OnPrimaryContainerDark = Color(0xFFE8EAEC)
val SecondaryDark = Color(0xFFC6C8CA)
val OnSecondaryDark = Color(0xFF303234)
val SecondaryContainerDark = Color(0xFF44474A)
val OnSecondaryContainerDark = Color(0xFFE2E4E6)
val TertiaryDark = Color(0xFF8FA4B8)
val OnTertiaryDark = Color(0xFF1A2235)
val BackgroundDark = Color(0xFF1C1B1F)
val OnBackgroundDark = Color(0xFFE6E1E5)
val SurfaceDark = Color(0xFF1C1B1F)
val OnSurfaceDark = Color(0xFFE6E1E5)
val SurfaceVariantDark = Color(0xFF44474A)
val OnSurfaceVariantDark = Color(0xFFCACCCE)
val ErrorDark = Color(0xFFFFB4AB)
val OnErrorDark = Color(0xFF690005)
